﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   多重待ちに関する C 言語用の型や定数の宣言
 */

#pragma once

//--------------------------------------------------------------------------
//  C 向けの宣言
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
/**
 * @brief   多重待ちオブジェクトのメッセージキュー待ちタイプの列挙型です。
 */
enum nnosMessageQueueWaitType
{
    /**
     * @brief   メッセージキューに空きが出来るまで待つ
     */
    nnosMessageQueueWaitType_WaitForNotFull  = 1,

    /**
     * @brief   メッセージキューが空でなくなるまで待つ
     */
    nnosMessageQueueWaitType_WaitForNotEmpty = 2,
};
