﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   条件変数に関する C 言語用の列挙型の定義
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/detail/os_MacroImpl.h>

//--------------------------------------------------------------------------
//  for C
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
/**
 * @brief   時限付き条件変数待ち機能の返値を表す列挙型です。
 */
typedef enum
{
    nnosConditionVariableStatus_Timeout     = 0,    //!< タイムアウトしました
    nnosConditionVariableStatus_NoTimeout   = 1,    //!< タイムアウト以外で起床しました
} nnosConditionVariableStatus;

