﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief         mbuf 関連のデータ構造と定数とを定義します。
 */

#pragma once

#include <nnc/mbuf/mbuf_Macro.h>
#include <nnc/mbuf/detail/mbuf_TypesPrivate.h>

/**
 @brief         mbuf の確保方法です。
 */
typedef enum
{
    nnmbufMbufAllocationMode_DontWait = 0,                 //!<　即座に確保できない場合はエラーを返します。
    nnmbufMbufAllocationMode_Wait     = 1,                 //!< 確保できるまでブロックします。
} nnmbufMbufAllocationMode;

/**
 @brief         mbuf におけるパケットの扱いに関するフラグです。
 */
typedef enum
{
    nnmbufMbufPacketHeaderFlag_Broadcast = 0x0200,         //!< Broadcast パケットです。
    nnmbufMbufPacketHeaderFlag_Multicast = 0x0400,         //!< Multicast パケットです。
    nnmbufMbufPacketHeaderFlag_Loopback  = 0x0800,         //!< Loopback パケットです。
} nnmbufMbufPacketHeaderFlag;

enum
{
    //! @ref nnmbufMbufCopydata() で mbuf チェインの最後までコピーするために指定します。
    nnmbufMbufCopyall   = 1000000000,

    //! mbuf のヘッダサイズです。
    nndetailMbufMbufHeaderSize = sizeof(void*) * 3 + sizeof(uint16_t) * 8 +
                                 sizeof(nndetailMbufMacAddress) * 2,

    //! mbuf の最小サイズです。
    nnmbufMbufUnitSizeMin = 64,

    //! mbuf の最大サイズです。
    nnmbufMbufUnitSizeMax = 65535,

    //! mbuf のデータ領域の最小サイズです。
    nnmbufMbufDataSizeMin = nnmbufMbufUnitSizeMin - nndetailMbufMbufHeaderSize,

    //! mbuf のデータ領域の最大サイズです。
    nnmbufMbufDataSizeMax = nnmbufMbufUnitSizeMax - nndetailMbufMbufHeaderSize,

    //! type の最小値です。
    nnmbufTypeMin = 0,

    //! type の最大値です。
    nnmbufTypeMax = 65535
};

/**
 * @brief       mbuf のデータ構造です。
 */
typedef struct nnmbufMbuf
{
    struct nnmbufMbuf*     _pNext;                         //!< 次のクラスタへのポインタ
    struct nnmbufMbuf*     _pPrev;                         //!< 前のクラスタへのポインタ
    void*                  _pGeneral;                      //!< 任意の用途に利用出来るポインタ
    uint16_t               _len;                           //!< data 領域に格納されているデータ長
    uint16_t               _capacity;                      //!< data 領域に格納できる最大長
    uint16_t               _top;                           //!< data 領域の先頭から実際のデータまでのオフセット値
    uint16_t               _flags;                         //!< @ref nnmbufMbufPacketHeaderFlag の 論理和
    uint16_t               _protocol;                      //!< Protocol id（ソケットおよび関連モジュール用）
    uint16_t               _owner;                         //!< オーナーモジュール
    uint16_t               _type;                          //!< 用途
    uint16_t               _pool;                          //!< どのバッファプールに確保されているかを示す識別子
    nndetailMbufMacAddress _dst;                           //!< 宛先 MAC アドレス
    nndetailMbufMacAddress _src;                           //!< 送信元 MAC アドレス
    char                   _data[nnmbufMbufDataSizeMax];   //!< データ領域
}
nnmbufMbuf;
