﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/utilTool/utilTool_CommandLog.h>

#define NN_UTILTOOL_RESULT_THROW(r) \
    do { \
    \
        const auto& nn_utiltool_result_throw_temporary((r)); \
        NN_UTILTOOL_LOG_DEBUG("Throw result(v=0x%08x, desc=%d, module=%d)", nn_utiltool_result_throw_temporary.GetInnerValueForDebug(), nn_utiltool_result_throw_temporary.GetDescription(), nn_utiltool_result_throw_temporary.GetModule()); \
        NN_UTILTOOL_LOG_DEBUG("Code: %s", #r); \
        NN_RESULT_THROW(nn_utiltool_result_throw_temporary); \
    } while (0)

#define NN_UTILTOOL_RESULT_THROW_UNLESS(condition, r, exp) \
    if (condition) {} \
    else \
    { \
        NN_UTILTOOL_LOG_DEBUG("Throw result(v=0x%08x, desc=%d, module=%d)", r.GetInnerValueForDebug(), r.GetDescription(), r.GetModule()); \
        NN_UTILTOOL_LOG_DEBUG("Code: %s", exp); \
        NN_RESULT_THROW(r); \
    }

#define NN_UTILTOOL_RESULT_DO(r) \
    do \
    { \
        const auto& _nn_result_do_temporary((r)); \
        NN_UTILTOOL_RESULT_THROW_UNLESS(_nn_result_do_temporary.IsSuccess(), _nn_result_do_temporary, #r); \
    } while (NN_STATIC_CONDITION(0))

#define NN_UTILTOOL_ABORT_UNLESS_RESULT_SUCCESS(r) \
    do \
    { \
        const auto& _nn_utiltool_abort_unress_result_success_temporary((r)); \
        if (_nn_utiltool_abort_unress_result_success_temporary.IsFailure()) \
        { \
            NN_UTILTOOL_LOG_ERROR("Abort result failure(desc=%d, module=%d)", \
            _nn_utiltool_abort_unress_result_success_temporary.GetDescription(), \
            _nn_utiltool_abort_unress_result_success_temporary.GetModule()); \
            NN_UTILTOOL_LOG_ERROR("Code: %s", #r); \
        } \
        NN_ABORT_UNLESS_RESULT_SUCCESS(_nn_utiltool_abort_unress_result_success_temporary); \
    } while (NN_STATIC_CONDITION(0))
