﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      tics モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_TICS_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tics, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_TICS_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_TICS_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_TICS_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_TICS_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(tics, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_TICS_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tics, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_TICS_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tics, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_TICS_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tics, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_TICS_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(tics, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_TICS_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tics, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_TICS_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tics, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_TICS_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tics, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_TICS_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tics, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_TICS_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_TICS_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_TICS_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_TICS_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tics, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_TICS_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_TICS_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_TICS_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(tics, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_TICS_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Trace, 0, format, args)
#define NN_DETAIL_TICS_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Trace, 1, format, args)
#define NN_DETAIL_TICS_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Trace, 2, format, args)
#define NN_DETAIL_TICS_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Trace, 3, format, args)

#define NN_DETAIL_TICS_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Info, 0, format, args)
#define NN_DETAIL_TICS_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Info, 1, format, args)
#define NN_DETAIL_TICS_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Info, 2, format, args)
#define NN_DETAIL_TICS_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Info, 3, format, args)

#define NN_DETAIL_TICS_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Warn, 0, format, args)
#define NN_DETAIL_TICS_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Warn, 1, format, args)
#define NN_DETAIL_TICS_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Warn, 2, format, args)
#define NN_DETAIL_TICS_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Warn, 3, format, args)

#define NN_DETAIL_TICS_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Error, 0, format, args)
#define NN_DETAIL_TICS_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Error, 1, format, args)
#define NN_DETAIL_TICS_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Error, 2, format, args)
#define NN_DETAIL_TICS_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Error, 3, format, args)

#define NN_DETAIL_TICS_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Fatal, 0, format, args)
#define NN_DETAIL_TICS_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Fatal, 1, format, args)
#define NN_DETAIL_TICS_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Fatal, 2, format, args)
#define NN_DETAIL_TICS_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(tics, Fatal, 3, format, args)

#define NN_DETAIL_TICS_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tics, Trace, 0, text, length)
#define NN_DETAIL_TICS_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Trace, 1, text, length)
#define NN_DETAIL_TICS_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Trace, 2, text, length)
#define NN_DETAIL_TICS_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Trace, 3, text, length)

#define NN_DETAIL_TICS_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(tics, Info, 0, text, length)
#define NN_DETAIL_TICS_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tics, Info, 1, text, length)
#define NN_DETAIL_TICS_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tics, Info, 2, text, length)
#define NN_DETAIL_TICS_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tics, Info, 3, text, length)

#define NN_DETAIL_TICS_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(tics, Warn, 0, text, length)
#define NN_DETAIL_TICS_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tics, Warn, 1, text, length)
#define NN_DETAIL_TICS_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tics, Warn, 2, text, length)
#define NN_DETAIL_TICS_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tics, Warn, 3, text, length)

#define NN_DETAIL_TICS_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tics, Error, 0, text, length)
#define NN_DETAIL_TICS_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Error, 1, text, length)
#define NN_DETAIL_TICS_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Error, 2, text, length)
#define NN_DETAIL_TICS_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Error, 3, text, length)

#define NN_DETAIL_TICS_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tics, Fatal, 0, text, length)
#define NN_DETAIL_TICS_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Fatal, 1, text, length)
#define NN_DETAIL_TICS_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Fatal, 2, text, length)
#define NN_DETAIL_TICS_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(tics, Fatal, 3, text, length)
