﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_StaticAssert.h>
#include <nn/nn_Version.h>

#define NN_SVC_VERSION_MAJOR    (NN_SDK_VERSION_MAJOR + 4)
#define NN_SVC_VERSION_MINOR    NN_SDK_VERSION_MINOR

// 互換性が切れたため、これ以前を要求するプログラムは実行できない
// (本当は Major Version が 3 -> 4 で互換性が切れているが、諸般の事情により更新できない)
#define NN_SVC_REQUIRED_VERSION_MAJOR    3
#define NN_SVC_REQUIRED_VERSION_MINOR    0

#define NN_SVC_VERSION_MAJOR_SHIFT  4
#define NN_SVC_VERSION_MINOR_SHIFT  0
#define NN_SVC_VERSION_MAJOR_MASK   (((1u << 13) - 1) << NN_SVC_VERSION_MAJOR_SHIFT)
#define NN_SVC_VERSION_MINOR_MASK   (((1u << 4) - 1)  << NN_SVC_VERSION_MINOR_SHIFT)

#define NN_SVC_VERSION_NUMBER(major, minor) \
    (((major) << NN_SVC_VERSION_MAJOR_SHIFT) | ((minor) << NN_SVC_VERSION_MINOR_SHIFT))

#define NN_SVC_MAJOR_VERSION(version) \
     (((version) & NN_SVC_VERSION_MAJOR_MASK) >> NN_SVC_VERSION_MAJOR_SHIFT)

#define NN_SVC_MINOR_VERSION(version) \
     (((version) & NN_SVC_VERSION_MINOR_MASK) >> NN_SVC_VERSION_MINOR_SHIFT)

NN_STATIC_ASSERT((NN_SVC_VERSION_MAJOR & ~((1u << 13) - 1)) == 0);
NN_STATIC_ASSERT((NN_SVC_VERSION_MINOR & ~((1u << 4) - 1)) == 0);

