﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_BaseType.h>

#ifdef __cplusplus

namespace nn {
namespace svc {
namespace aarch32 {

    Result  SetHeapSize                    (uintptr_t* pOut, size_t size);
    Result  SetMemoryPermission            (uintptr_t addr, size_t size, nn::svc::MemoryPermission permission);
    Result  SetMemoryAttribute             (uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute);
    Result  MapMemory                      (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  UnmapMemory                    (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  QueryMemory                    (nn::svc::ilp32::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr);
    void    ExitProcess                    ();
    Result  CreateThread                   (nn::svc::Handle* pOut, nn::svc::ilp32::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore);
    Result  StartThread                    (nn::svc::Handle thread);
    void    ExitThread                     ();
    void    SleepThread                    (int64_t ns);
    Result  GetThreadPriority              (int32_t* pOut, nn::svc::Handle thread);
    Result  SetThreadPriority              (nn::svc::Handle thread, int32_t priority);
    Result  GetThreadCoreMask              (int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread);
    Result  SetThreadCoreMask              (nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask);
    int32_t GetCurrentProcessorNumber      ();
    Result  SignalEvent                    (nn::svc::Handle event);
    Result  ClearEvent                     (nn::svc::Handle event);
    Result  MapSharedMemory                (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  UnmapSharedMemory              (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  CreateTransferMemory           (nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  CloseHandle                    (nn::svc::Handle handle);
    Result  ResetSignal                    (nn::svc::Handle handle);
    Result  WaitSynchronization            (int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns);
    Result  CancelSynchronization          (nn::svc::Handle handle);
    Result  ArbitrateLock                  (nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue);
    Result  ArbitrateUnlock                (uintptr_t addr);
    Result  WaitProcessWideKeyAtomic       (uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns);
    void    SignalProcessWideKey           (uintptr_t cvKey, int32_t num);
    int64_t GetSystemTick                  ();
    Result  ConnectToNamedPort             (nn::svc::Handle* pOut, const char name[]);
    Result  SendSyncRequestLight           (nn::svc::Handle session);
    Result  SendSyncRequest                (nn::svc::Handle session);
    Result  SendSyncRequestWithUserBuffer  (uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SendAsyncRequestWithUserBuffer (nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  GetProcessId                   (nn::Bit64* pOut, nn::svc::Handle process);
    Result  GetThreadId                    (nn::Bit64* pOut, nn::svc::Handle thread);
    void    Break                          (nn::svc::BreakReason reason, uintptr_t data, size_t length);
    Result  OutputDebugString              (const char text[], size_t length);
    void    ReturnFromException            (nn::Result result);
    Result  GetInfo                        (nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param);
    void    FlushEntireDataCache           ();
    Result  FlushDataCache                 (uintptr_t addr, size_t size);
    Result  MapPhysicalMemory              (uintptr_t addr, size_t size);
    Result  UnmapPhysicalMemory            (uintptr_t addr, size_t size);
    Result  GetLastThreadInfo              (nn::svc::ilp32::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag);
    Result  GetResourceLimitLimitValue     (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  GetResourceLimitCurrentValue   (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SetThreadActivity              (nn::svc::Handle handle, nn::svc::ThreadActivity activity);
    Result  GetThreadContext3              (nn::svc::ThreadContext* pContext, nn::svc::Handle handle);
    Result  WaitForAddress                 (uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns);
    Result  SignalToAddress                (uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num);
    void    KernelDebug                    (nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2);
    void    ChangeKernelTraceState         (nn::svc::KernelTraceState state);
    Result  CreateCodeMemory               (nn::svc::Handle* pOut, uintptr_t addr, size_t size);
    Result  ControlCodeMemory              (nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission);
    Result  ReadWriteRegister              (nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value);
    Result  SetProcessActivity             (nn::svc::Handle handle, nn::svc::ProcessActivity activity);

} // end of namespace aarch32
} // end of namespace svc
} // end of namespace nn

#endif  // ifdef __cplusplus

