﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief サービスフレームワークで HIPC を使用する際に、サーバで用いるポート関連の API を定義します。
    @details
     このヘッダで提供される関数の仕様は、今後変更される(破壊的な変更も含む)可能性があります。

     このファイルは <nn/sf/sf_HipcServer.h> をインクルードすることでインクルードされます。
*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>
#include <nn/sf/sf_HipcPortCommon.h>

#include <nn/sf/hipc/sf_HipcDirectApi.h>
#include <nn/sf/hipc/sf_HipcServiceResolutionApi.h>

namespace nn { namespace sf {

//! @name HIPC サービス登録
//! @{

/**
    @brief サーバポートハンドルを閉じます。

    @param[in] handle 閉じるハンドルを指定します。
*/
void CloseHipcServerPortHandle(HipcServerPortHandle handle) NN_NOEXCEPT;

//! @}

// 以下実装
//   TODO: 整理後 .cpp への移動

inline void CloseHipcServerPortHandle(HipcServerPortHandle handle) NN_NOEXCEPT
{
    hipc::CloseServerPortHandle(handle);
}

}}
