﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>

#include <nn/TargetConfigs/build_Os.h>
#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include <nn/sf/hipc/sf_HipcServiceResolutionApi-os.win32.h>
#endif

namespace nn { namespace sf { namespace hipc {

// common global
void InitializeHipcServiceResolution() NN_NOEXCEPT;
void FinalizeHipcServiceResolution() NN_NOEXCEPT;

const size_t HipcServiceNameLengthMax = 8;

// for Server
Result RegisterHipcService(HipcServerPortHandle* pOut, int32_t maxSessions, const char* name) NN_NOEXCEPT;
void UnregisterHipcService(const char* name) NN_NOEXCEPT;

// for Client
bool IsHipcServiceRegistered(const char* name) NN_NOEXCEPT;
Result ConnectToHipcService(HipcClientSessionHandle* pOut, const char* name) NN_NOEXCEPT;
Result TryConnectToHipcService(bool* pValid, HipcClientSessionHandle* pOut, const char* name) NN_NOEXCEPT;

}}}
