﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/hipc/sf_HipcDirectApi.h>
#include <nn/sf/hipc/sf_HipcServiceResolutionApi.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #define NN_SF_DETAIL_MULTIPLE_SERVER_API_MODEL_AVAILABLE 1  // NOLINT(preprocessor/const)
    #include <nn/sf/hipc/server/sf_HipcServerApiModel-os.win32.h>
#else
    #define NN_SF_DETAIL_MULTIPLE_SERVER_API_MODEL_AVAILABLE 0  // NOLINT(preprocessor/const)
#endif

namespace nn { namespace sf { namespace hipc { namespace server {

#if NN_SF_DETAIL_MULTIPLE_SERVER_API_MODEL_AVAILABLE

class HipcServerApiModelHolder
{
private:
    HipcServerApiModel* m_pHolder;
public:
    explicit HipcServerApiModelHolder(HipcServerApiModel* pHolder) NN_NOEXCEPT
        : m_pHolder(pHolder)
    {
    }
    HipcServerApiModel* GetHipcServerApiModel() const NN_NOEXCEPT
    {
        return m_pHolder;
    }
    void SetHipcServerApiModel(HipcServerApiModel* pHolder) NN_NOEXCEPT
    {
        m_pHolder = pHolder;
    }
    Result CreatePort(HipcServerPortHandle* pOutServer, HipcClientPortHandle* pOutClient, int maxSessions) NN_NOEXCEPT
    {
        return m_pHolder->CreatePort(pOutServer, pOutClient, maxSessions);
    }
    Result CreateSession(HipcServerSessionHandle* pOutServer, HipcClientSessionHandle* pOutClient) NN_NOEXCEPT
    {
        return m_pHolder->CreateSession(pOutServer, pOutClient);
    }
    Result RegisterHipcService(HipcServerPortHandle* pOut, int32_t maxSessions, const char* name) NN_NOEXCEPT
    {
        return m_pHolder->RegisterHipcService(pOut, maxSessions, name);
    }
    void UnregisterHipcService(const char* name) NN_NOEXCEPT
    {
        return m_pHolder->UnregisterHipcService(name);
    }
};

HipcServerApiModel* GetDefaultServerApiModel() NN_NOEXCEPT;
HipcServerApiModel* GetWindowsIpcEnabledServerApiModel() NN_NOEXCEPT;

#else

struct HipcServerApiModel
{
};

class HipcServerApiModelHolder
{
public:
    explicit HipcServerApiModelHolder(HipcServerApiModel*) NN_NOEXCEPT
    {
    }
    HipcServerApiModel* GetHipcServerApiModel() const NN_NOEXCEPT
    {
        return nullptr;
    }
    void SetHipcServerApiModel(HipcServerApiModel*) NN_NOEXCEPT
    {
    }
    Result CreatePort(HipcServerPortHandle* pOutServer, HipcClientPortHandle* pOutClient, int maxSessions) NN_NOEXCEPT
    {
        return hipc::CreatePort(pOutServer, pOutClient, maxSessions);
    }
    Result CreateSession(HipcServerSessionHandle* pOutServer, HipcClientSessionHandle* pOutClient) NN_NOEXCEPT
    {
        return hipc::CreateSession(pOutServer, pOutClient);
    }
    Result RegisterHipcService(HipcServerPortHandle* pOut, int32_t maxSessions, const char* name) NN_NOEXCEPT
    {
        return hipc::RegisterHipcService(pOut, maxSessions, name);
    }
    void UnregisterHipcService(const char* name) NN_NOEXCEPT
    {
        return hipc::UnregisterHipcService(name);
    }
};

inline HipcServerApiModel* GetDefaultServerApiModel() NN_NOEXCEPT
{
    return nullptr;
}

inline HipcServerApiModel* GetWindowsIpcEnabledServerApiModel() NN_NOEXCEPT
{
    return nullptr;
}
#endif

}}}}
