﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/cmif/client/sf_CmifDomainClientMessage.h>
#include <nn/sf/hipc/client/sf_HipcClientSessionManagedProxyKind.h>
#include <nn/sf/cmif/client/sf_CmifProxyFactory.h>

namespace nn { namespace sf { namespace hipc { namespace client {

class HipcClientSessionManager
    : private HipcClientSessionAllocator
{
private:

    Result ConvertToDomainImpl(cmif::CmifDomainObjectId* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT;

    typedef cmif::client::CmifDomainProxy<hipc::client::Hipc2ClientSessionManagedProxyKind> DomainProxyKind;

public:

    Result CreateNewSession(HipcClientSessionHandle* pOut) NN_NOEXCEPT;

    template <typename Interface, typename AllocationPolicy>
    Result InitializeByHandle(SharedPointer<Interface>* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT
    {
        cmif::CmifDomainObjectId id;
        NN_RESULT_DO(ConvertToDomainImpl(&id, handle));
        typedef cmif::client::CmifProxyFactory<
            Interface,
            DomainProxyKind,
            AllocationPolicy
        > ProxyFactory;
        typename DomainProxyKind::ObjectInfo objectInfo;
        objectInfo.baseInfo = this;
        objectInfo.id = id;
        *pOut = SharedPointer<Interface>(ProxyFactory::CreateProxyObject(objectInfo), false);
        NN_RESULT_SUCCESS;
    }

    template <typename Interface, typename AllocationPolicy>
    Result InitializeByHandle(SharedPointer<Interface>* pOut, typename AllocationPolicy::Allocator* pAllocator, HipcClientSessionHandle handle) NN_NOEXCEPT
    {
        cmif::CmifDomainObjectId id;
        NN_RESULT_DO(ConvertToDomainImpl(&id, handle));
        typedef cmif::client::CmifProxyFactory<
            Interface,
            DomainProxyKind,
            AllocationPolicy
        > ProxyFactory;
        typename DomainProxyKind::ObjectInfo objectInfo;
        objectInfo.baseInfo = this;
        objectInfo.id = id;
        *pOut = SharedPointer<Interface>(ProxyFactory::CreateProxyObject(pAllocator, objectInfo), false);
        NN_RESULT_SUCCESS;
    }

};

}}}}
