﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>

namespace nn { namespace sf { namespace detail {

struct StaticMutex
{
    os::MutexType _mutex;

    void lock() NN_NOEXCEPT
    {
        os::LockMutex(&_mutex);
    }

    void unlock() NN_NOEXCEPT
    {
        os::UnlockMutex(&_mutex);
    }
};

#define NN_SF_DETAIL_STATIC_MUTEX_INITIALIZER(recursive) { NN_OS_MUTEX_INITIALIZER(recursive) }

}}}
