﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ro { namespace detail { // NOLINT(whitespace/braces)

class IRoInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IRoInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IRoInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(MapManualLoadModuleMemory, (::nn::sf::Out<::std::uint64_t> pOut, ::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnmapManualLoadModuleMemory, (::nn::Bit64 pid, ::std::uint64_t imageAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterModuleInfo, (::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterModuleInfo, (::nn::Bit64 pid, ::std::uint64_t imageAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProcessHandle, (::nn::Bit64 pid, ::nn::sf::NativeHandle&& process))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IRoInterface)

        ::nn::Result MapManualLoadModuleMemory(::nn::sf::Out<::std::uint64_t> pOut, ::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(MapManualLoadModuleMemory, (pOut, pid, imageAddress, imageSize, bufferAddress, bufferSize));
        }

        ::nn::Result UnmapManualLoadModuleMemory(::nn::Bit64 pid, ::std::uint64_t imageAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnmapManualLoadModuleMemory, (pid, imageAddress));
        }

        ::nn::Result RegisterModuleInfo(::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterModuleInfo, (pid, imageAddress, imageSize));
        }

        ::nn::Result UnregisterModuleInfo(::nn::Bit64 pid, ::std::uint64_t imageAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterModuleInfo, (pid, imageAddress));
        }

        ::nn::Result RegisterProcessHandle(::nn::Bit64 pid, ::nn::sf::NativeHandle&& process) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterProcessHandle, (pid, ::std::move(process)));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IRoInterface
    {
    public:
        nn::Result MapManualLoadModuleMemory(nn::sf::Out<std::uint64_t> pOut, nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT;
        nn::Result UnmapManualLoadModuleMemory(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT;
        nn::Result RegisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize) NN_NOEXCEPT;
        nn::Result UnregisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT;
        nn::Result RegisterProcessHandle(nn::Bit64 pid, nn::sf::NativeHandle&& process) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result MapManualLoadModuleMemory(nn::sf::Out<std::uint64_t> pOut, nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT;
    nn::Result UnmapManualLoadModuleMemory(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT;
    nn::Result RegisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize) NN_NOEXCEPT;
    nn::Result UnregisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT;
    nn::Result RegisterProcessHandle(nn::Bit64 pid, nn::sf::NativeHandle&& process) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ro::detail::IRoInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MapManualLoadModuleMemory, (::nn::sf::Out<::std::uint64_t> pOut, ::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(MapManualLoadModuleMemory, (pOut, pid, imageAddress, imageSize, bufferAddress, bufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmapManualLoadModuleMemory, (::nn::Bit64 pid, ::std::uint64_t imageAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnmapManualLoadModuleMemory, (pid, imageAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterModuleInfo, (::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterModuleInfo, (pid, imageAddress, imageSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterModuleInfo, (::nn::Bit64 pid, ::std::uint64_t imageAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterModuleInfo, (pid, imageAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProcessHandle, (::nn::Bit64 pid, ::nn::sf::NativeHandle&& process))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterProcessHandle, (pid, ::std::move(process)));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ro::detail::IRoInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ro::detail::IRoInterface))

    // nn::Result MapManualLoadModuleMemory(nn::sf::Out<std::uint64_t> pOut, nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MapManualLoadModuleMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageAddress, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageSize, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferAddress, (::std::uint64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferSize, (::std::uint64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (pid, imageAddress, imageSize, bufferAddress, bufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MapManualLoadModuleMemory)

    // nn::Result UnmapManualLoadModuleMemory(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnmapManualLoadModuleMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageAddress, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (pid, imageAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnmapManualLoadModuleMemory)

    // nn::Result RegisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterModuleInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageAddress, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (pid, imageAddress, imageSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterModuleInfo)

    // nn::Result UnregisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterModuleInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageAddress, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (pid, imageAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterModuleInfo)

    // nn::Result RegisterProcessHandle(nn::Bit64 pid, nn::sf::NativeHandle&& process) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterProcessHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(process, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (process))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(process)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterProcessHandle)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ro::detail::IRoInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ro::detail::IRoInterface))

    // nn::Result MapManualLoadModuleMemory(nn::sf::Out<std::uint64_t> pOut, nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MapManualLoadModuleMemory, (::nn::sf::Out<::std::uint64_t> pOut, ::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MapManualLoadModuleMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MapManualLoadModuleMemory)
    }

    // nn::Result UnmapManualLoadModuleMemory(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmapManualLoadModuleMemory, (::nn::Bit64 pid, ::std::uint64_t imageAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnmapManualLoadModuleMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnmapManualLoadModuleMemory)
    }

    // nn::Result RegisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress, std::uint64_t imageSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterModuleInfo, (::nn::Bit64 pid, ::std::uint64_t imageAddress, ::std::uint64_t imageSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterModuleInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterModuleInfo)
    }

    // nn::Result UnregisterModuleInfo(nn::Bit64 pid, std::uint64_t imageAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterModuleInfo, (::nn::Bit64 pid, ::std::uint64_t imageAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterModuleInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterModuleInfo)
    }

    // nn::Result RegisterProcessHandle(nn::Bit64 pid, nn::sf::NativeHandle&& process) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProcessHandle, (::nn::Bit64 pid, ::nn::sf::NativeHandle&& process))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterProcessHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(process)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterProcessHandle)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ro::detail::IRoInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ro::detail::IRoInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MapManualLoadModuleMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MapManualLoadModuleMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnmapManualLoadModuleMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnmapManualLoadModuleMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterModuleInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterModuleInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterModuleInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterModuleInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterProcessHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(process)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterProcessHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(process)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MapManualLoadModuleMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnmapManualLoadModuleMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterModuleInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterModuleInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterProcessHandle)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ro::detail::IRoInterface))
