﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ro {
namespace detail {
    struct ExceptionInfo
    {
        uintptr_t moduleAddress;
        size_t    moduleSize;
        uintptr_t infoOffset; // Offset from moduleAddress
        size_t    infoSize;
    };

    //-----------------------------------------------------------------------------
    /**
     * @brief   Get ExceptionInfo of a module related to given PC value
     *
     * @param[out] pOutValue              ExceptionInfo
     * @param[in]  pc                     Program Counter
     *
     */
    bool GetExceptionInfo(ExceptionInfo* pOutValue, uintptr_t pc);
}
}}
