﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ovln/ovln_Services.sfdl.h>
#include <nn/nn_Allocator.h>

namespace nn { namespace ovln {

class NotificationAgent;

NotificationAgent* CreateNotificationAgent(MemoryResource* pMemoryResource) NN_NOEXCEPT;
void DestroyNotificationAgent(NotificationAgent* p) NN_NOEXCEPT;
sf::SharedPointer<ovln::IReceiverService> GetReceiverService(NotificationAgent* p) NN_NOEXCEPT;
sf::SharedPointer<ovln::ISenderService> GetSenderService(NotificationAgent* p) NN_NOEXCEPT;

}}
