﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>

namespace nn { namespace ovln { namespace format {

const uint32_t AccountUserStateChangeTag = 11000;

enum class AccountUserStateChangeKind : uint8_t
{
    Opened,
    Closed,
};

struct AccountUserStateChangeData
{
    AccountUserStateChangeKind kind;
    nn::account::Uid uid;
};
static_assert(std::is_pod<AccountUserStateChangeData>::value, "std::is_pod<AccountUserStateChangeData>");
static_assert(sizeof(AccountUserStateChangeData) == 24, "sizeof(AccountUserStateChangeData)");
static_assert(NN_ALIGNOF(AccountUserStateChangeData) == 8, "NN_ALIGNOF(AccountUserStateChangeData)");

}}}
