﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   ユーザー例外ハンドラで、システムプロセスを停止させるための API の宣言
*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/diag/detail/diag_DetailBuildSwitch.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>

namespace nn { namespace diag { namespace detail {

NN_NORETURN void AbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const Result* result,
    const nn::os::UserExceptionInfo* userExceptionInfo,
    const char* format,
    ...) NN_NOEXCEPT;

}}} // nn::diag::detail

#if defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)

#define NN_DETAIL_ABORT_FROM_USER_EXCEPTION_HANDLER_IMPL(exceptionInfo) \
    do { \
        nn::Result __result = nn::ResultSuccess(); \
        ::nn::diag::detail::AbortImpl("false", NN_CURRENT_FUNCTION_NAME, __FILE__, __LINE__, &__result, exceptionInfo, "NN_ABORT_FROM_USER_EXCEPTION_HANDLER"); \
    }while(0)

#else // defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)

#define NN_DETAIL_ABORT_FROM_USER_EXCEPTION_HANDLER_IMPL(exceptionInfo) \
    do { \
        nn::Result __result = nn::ResultSuccess(); \
        ::nn::diag::detail::AbortImpl("", "", "", 0, &__result, exceptionInfo, ""); \
    }while(0)

#endif // defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)

/**
* @brief 実行を停止します。このマクロは常に有効です。
*
* @param[in]  exceptionInfo     例外情報を格納するバッファ領域へのポインタ
*/
#define NN_ABORT_FROM_USER_EXCEPTION_HANDLER(exceptionInfo) \
    NN_DETAIL_ABORT_FROM_USER_EXCEPTION_HANDLER_IMPL(exceptionInfo)
