﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/*!
 * @brief   非公開API
 */
namespace nn {

    inline bool IsCtr(Bit64 id)
    {
        return (static_cast<Bit32>(id>> 32) & 0xFFFFC000) == 0x00040000;
    }

    inline bool IsCafe(Bit64 id)
    {
        return (static_cast<Bit32>(id >> 32) & 0xFFFFC000) == 0x00050000;
    }

    inline bool IsNx(Bit64 id)
    {
        return (static_cast<Bit32>(id >> 32) & 0xFF000000) == 0x01000000;
    }

}
