﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/net/nnet.h>
#include <nn/net/nos/nos_compatible.h>

#pragma once

void* const NNET_CANCEL_MESSAGE = reinterpret_cast<void*>(0xffffffff);
const int NNET_MAX_SEND_LEN       = 1600;
const int NNET_MAX_RECV_LEN       = 1600;

/**
 *  ドライバが保持するプロトコル情報
 */

const int NNET_PROTOCOL_NUM = 8;        /* ARP, RARP, IP, PPPoE Discovery, PPPoE Session */

typedef struct NNETProtocolInfo
{
    u16               protocolId;                           /* IP、ARPなど */
    NNETInstance*     pUpperNetIns;                         /* 上位インスタンス */
    uintptr_t         rxId;                                 /* 登録時の識別 ID （ユーザ使用領域） */
} NNETProtocolInfo;

typedef struct NNETProtocolList
{
    NNETProtocolInfo    protocols[NNET_PROTOCOL_NUM];
    s32                 protocol_count;
} NNETProtocolList;

typedef struct NNETEthHeader
{
    u8      dst[NNET_ETH_ALEN];
    u8      src[NNET_ETH_ALEN];
    u16     type;
} NNETEthHeader;

const size_t NNET_ETH_HLEN = sizeof(NNETEthHeader);

typedef struct NNETIeeeHeader
{
    u8      dst[NNET_ETH_ALEN];
    u8      src[NNET_ETH_ALEN];
    u16     length;
    u8      dsap;      /* destination SAP type */
    u8      ssap;      /* source SAP type */
    u8      control;   /* control */
    u8      id[3];     /* ID */
    u16     type;      /* type */
} NNETIeeeHeader;

const int NNET_IEEE_HLEN = sizeof(NNETIeeeHeader);

extern const u8 NNETETHAddrBroadcast[NNET_ETH_ALEN];
extern const u8 NNETETHAddrAny[NNET_ETH_ALEN];

bool NNET_RegisterProtocols(NNETProtocolList* pProtocolList, const u16 protocols[], NNETInstance* pUpperNetIns, uintptr_t rxId);
bool NNET_UnregisterProtocols(NNETProtocolList* pProtocolList, const NNETInstance* pUpperNetIns, uintptr_t* pRxId);
NNETProtocolInfo* NNET_GetProtocolInfo(NNETProtocolList* pProtocolList, u16 protocol);

NOSMessageBuf* NNET_ConvertFrameToMbuf(const u8* dstMac, const u8* srcMac, u16 protocol, const u8* pBody, int bodyLen, u8 tag);
s32  NNET_HandleLoopback(NNETProtocolList* pProtocolList, NOSMessageBuf* mbuf, BOOL* bContinue);
void NNET_DumpProtocolList(const NNETProtocolList* pProtocolList);
void NNET_FreeBuffersInQueue(NOSMessageQueueId mqId);

void NNET_HandleDixFrameRaw(NNETProtocolList* pProtocolList, const u8* pFrame, int len, u8 tag);
void NNET_HandleIeeeFrameRaw(NNETProtocolList* pProtocolList, const u8* pFrame, int len, u8 tag);
void NNET_HandleIeeeFrame(NNETProtocolList* pProtocolList, NOSMessageBuf* mbuf);
s32 NNET_SendPreProcess(NOSMessageBuf** ppMbuf, u16* pLength, const u8* pSrcMac, const u8* pDstMac);
s32 NNET_SendPreProcessDix(NOSMessageBuf** ppMbuf, u16* pLength, const u8* pSrcMac, const u8* pDstMac);
