﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/kvdb/kvdb_BoundedString.h>

namespace nn { namespace ncm {

    class PackageInstallTaskBase : public InstallTaskBase
    {
    public:
        PackageInstallTaskBase() NN_NOEXCEPT : m_PackageRoot() {}

        Result Initialize(const char* packageRoot, void* buffer, size_t bufferSize, StorageId storage, InstallTaskDataBase* data, Bit32 config) NN_NOEXCEPT;

    protected:
        const char* GetPackageRootPath() NN_NOEXCEPT
        {
            return m_PackageRoot.Get();
        }

    private:
        typedef kvdb::BoundedString<256> InternalPath;
        InternalPath m_PackageRoot;

        virtual Result OnWritePlaceHolder(InstallContentInfo* data) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result InstallTicket(const nn::fs::RightsId& rightsId, ContentMetaType contentMetaType) NN_NOEXCEPT NN_OVERRIDE;

        void CreateContentPath(InternalPath* outValue, ContentId contentId) NN_NOEXCEPT;
        void CreateContentMetaPath(InternalPath* outValue, ContentId contentId) NN_NOEXCEPT;
        void CreateTicketPath(InternalPath* outValue, nn::fs::RightsId rightsId) NN_NOEXCEPT;
        void CreateCertificatePath(InternalPath* outValue, nn::fs::RightsId rightsId) NN_NOEXCEPT;

        void*  m_Buffer;
        size_t m_BufferSize;
    };
}}
