﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaId.h>

#include <nn/lr/lr_RegisteredLocations.h>
#include <nn/lr/lr_IAddOnContentLocationResolver.h>

namespace nn { namespace lr {

template<typename T, int SIZE>
using RegisteredStorages = RegisteredData<T, ncm::StorageId, SIZE>;

class AddOnContentLocationResolverImpl
{
    NN_DISALLOW_COPY(AddOnContentLocationResolverImpl);
    NN_DISALLOW_MOVE(AddOnContentLocationResolverImpl);

public:
    static const int MaxAddOnContentLocationCount = 2048;
    AddOnContentLocationResolverImpl() NN_NOEXCEPT {}

    Result ResolveAddOnContentPath(sf::Out<nn::lr::Path> outValue, ncm::DataId id) NN_NOEXCEPT;
    Result RegisterAddOnContentStorage(ncm::DataId id, ncm::StorageId storageId) NN_NOEXCEPT;
    Result UnregisterAllAddOnContentPath() NN_NOEXCEPT;
private:
    RegisteredStorages<ncm::DataId, MaxAddOnContentLocationCount> m_RegisteredAddOnContents;
};

}}
