﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      lmem モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_LMEM_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_LMEM_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_LMEM_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_LMEM_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_LMEM_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_LMEM_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(lmem, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_LMEM_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Trace, 0, format, args)
#define NN_DETAIL_LMEM_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Trace, 1, format, args)
#define NN_DETAIL_LMEM_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Trace, 2, format, args)
#define NN_DETAIL_LMEM_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Trace, 3, format, args)

#define NN_DETAIL_LMEM_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Info, 0, format, args)
#define NN_DETAIL_LMEM_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Info, 1, format, args)
#define NN_DETAIL_LMEM_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Info, 2, format, args)
#define NN_DETAIL_LMEM_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Info, 3, format, args)

#define NN_DETAIL_LMEM_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Warn, 0, format, args)
#define NN_DETAIL_LMEM_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Warn, 1, format, args)
#define NN_DETAIL_LMEM_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Warn, 2, format, args)
#define NN_DETAIL_LMEM_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Warn, 3, format, args)

#define NN_DETAIL_LMEM_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Error, 0, format, args)
#define NN_DETAIL_LMEM_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Error, 1, format, args)
#define NN_DETAIL_LMEM_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Error, 2, format, args)
#define NN_DETAIL_LMEM_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Error, 3, format, args)

#define NN_DETAIL_LMEM_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Fatal, 0, format, args)
#define NN_DETAIL_LMEM_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Fatal, 1, format, args)
#define NN_DETAIL_LMEM_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Fatal, 2, format, args)
#define NN_DETAIL_LMEM_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(lmem, Fatal, 3, format, args)

#define NN_DETAIL_LMEM_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Trace, 0, text, length)
#define NN_DETAIL_LMEM_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Trace, 1, text, length)
#define NN_DETAIL_LMEM_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Trace, 2, text, length)
#define NN_DETAIL_LMEM_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Trace, 3, text, length)

#define NN_DETAIL_LMEM_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Info, 0, text, length)
#define NN_DETAIL_LMEM_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Info, 1, text, length)
#define NN_DETAIL_LMEM_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Info, 2, text, length)
#define NN_DETAIL_LMEM_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Info, 3, text, length)

#define NN_DETAIL_LMEM_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Warn, 0, text, length)
#define NN_DETAIL_LMEM_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Warn, 1, text, length)
#define NN_DETAIL_LMEM_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Warn, 2, text, length)
#define NN_DETAIL_LMEM_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Warn, 3, text, length)

#define NN_DETAIL_LMEM_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Error, 0, text, length)
#define NN_DETAIL_LMEM_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Error, 1, text, length)
#define NN_DETAIL_LMEM_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Error, 2, text, length)
#define NN_DETAIL_LMEM_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Error, 3, text, length)

#define NN_DETAIL_LMEM_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Fatal, 0, text, length)
#define NN_DETAIL_LMEM_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Fatal, 1, text, length)
#define NN_DETAIL_LMEM_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Fatal, 2, text, length)
#define NN_DETAIL_LMEM_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(lmem, Fatal, 3, text, length)
