﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  htclow のモジュール内チャネルに関するユーティリティクラス
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/result/result_HandlingUtility.h>

#include <nn/htclow/htclow_Module.h>
#include <nn/htclow/htclow_ChannelTypes.h>
#include <nn/htclow/htclow_ChannelApi.h>

namespace nn { namespace htclow {

/**
*   @brief      htclow のモジュール内チャネルに関するユーティリティクラス
*/
class Channel final
{
public:
    Channel() NN_NOEXCEPT
    {
    }

    Channel(const Module* pModule, ChannelId id) NN_NOEXCEPT
    {
        Open(pModule, id);
    }

    ~Channel() NN_NOEXCEPT
    {
        Close();
    }

    ChannelType* GetBase() NN_NOEXCEPT
    {
        return &m_Impl;
    }

    nn::Result Open(const Module* pModule, ChannelId id) NN_NOEXCEPT
    {
        nn::htclow::InitializeChannel(&m_Impl, pModule->GetBase(), id);
        return nn::htclow::OpenChannel(&m_Impl);
    }

    nn::Result Connect() NN_NOEXCEPT
    {
        return nn::htclow::ConnectChannel(&m_Impl);
    }

    nn::Result Send(size_t* pOutSize, const void* pBuffer, size_t bufferSize) NN_NOEXCEPT
    {
        return nn::htclow::Send(pOutSize, pBuffer, bufferSize, &m_Impl);
    }

    nn::Result Receive(size_t* pOutSize, void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT
    {
        return nn::htclow::Receive(pOutSize, pOutBuffer, bufferSize, &m_Impl);
    }

    void Shutdown() NN_NOEXCEPT
    {
        nn::htclow::ShutdownChannel(&m_Impl);
    }

    void Close() NN_NOEXCEPT
    {
        nn::htclow::CloseChannel(&m_Impl);
        nn::htclow::FinalizeChannel(&m_Impl);
    }

private:
    ChannelType m_Impl;
};

}}
