﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  htclow の通常用 API
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace htclow {

/**
*   @brief      htclow の通常用 API を初期化
*
*   @details    通常用 API を実行するための htclow ライブラリの初期化を行います。
*/
void Initialize() NN_NOEXCEPT;

/**
*   @brief      ホストとの通信が確立されたことを通知するイベントオブジェクトにバインド
*
*   @pre        通常用 API の初期化を実行済
*
*   @param[out] pOutEvent イベントオブジェクトを指すポインタ
*
*   @details    ホストとの通信が確立されたことを通知するイベントオブジェクトにバインドします。@n
*               イベントは読み取り専用で、シグナル・クリアともに htclow ライブラリ側で行われます。@n
*               ホストと接続中はシグナル状態で、切断中はクリア状態になります。
*/
void BindHostConnectionEvent(nn::os::SystemEvent* pOutEvent) NN_NOEXCEPT;

/**
*   @brief      ホストとの通信が切断されたことを通知するイベントオブジェクトにバインド
*
*   @pre        通常用 API の初期化を実行済
*
*   @param[out] pOutEvent イベントオブジェクトを指すポインタ
*
*   @details    ホストとの通信が切断されたことを通知するイベントオブジェクトにバインドします。@n
*               イベントは読み取り専用で、シグナル・クリアともに htclow ライブラリ側で行われます。@n
*               ホストと切断中はシグナル状態で、接続中はクリア状態になります。
*/
void BindHostDisconnectionEvent(nn::os::SystemEvent* pOutEvent) NN_NOEXCEPT;

}}
