﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      htclow モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_HTCLOW_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTCLOW_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTCLOW_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTCLOW_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTCLOW_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTCLOW_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htclow, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTCLOW_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Trace, 0, format, args)
#define NN_DETAIL_HTCLOW_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Trace, 1, format, args)
#define NN_DETAIL_HTCLOW_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Trace, 2, format, args)
#define NN_DETAIL_HTCLOW_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Trace, 3, format, args)

#define NN_DETAIL_HTCLOW_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Info, 0, format, args)
#define NN_DETAIL_HTCLOW_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Info, 1, format, args)
#define NN_DETAIL_HTCLOW_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Info, 2, format, args)
#define NN_DETAIL_HTCLOW_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Info, 3, format, args)

#define NN_DETAIL_HTCLOW_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Warn, 0, format, args)
#define NN_DETAIL_HTCLOW_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Warn, 1, format, args)
#define NN_DETAIL_HTCLOW_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Warn, 2, format, args)
#define NN_DETAIL_HTCLOW_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Warn, 3, format, args)

#define NN_DETAIL_HTCLOW_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Error, 0, format, args)
#define NN_DETAIL_HTCLOW_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Error, 1, format, args)
#define NN_DETAIL_HTCLOW_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Error, 2, format, args)
#define NN_DETAIL_HTCLOW_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Error, 3, format, args)

#define NN_DETAIL_HTCLOW_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Fatal, 0, format, args)
#define NN_DETAIL_HTCLOW_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Fatal, 1, format, args)
#define NN_DETAIL_HTCLOW_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Fatal, 2, format, args)
#define NN_DETAIL_HTCLOW_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htclow, Fatal, 3, format, args)

#define NN_DETAIL_HTCLOW_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Trace, 0, text, length)
#define NN_DETAIL_HTCLOW_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Trace, 1, text, length)
#define NN_DETAIL_HTCLOW_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Trace, 2, text, length)
#define NN_DETAIL_HTCLOW_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Trace, 3, text, length)

#define NN_DETAIL_HTCLOW_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Info, 0, text, length)
#define NN_DETAIL_HTCLOW_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Info, 1, text, length)
#define NN_DETAIL_HTCLOW_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Info, 2, text, length)
#define NN_DETAIL_HTCLOW_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Info, 3, text, length)

#define NN_DETAIL_HTCLOW_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Warn, 0, text, length)
#define NN_DETAIL_HTCLOW_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Warn, 1, text, length)
#define NN_DETAIL_HTCLOW_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Warn, 2, text, length)
#define NN_DETAIL_HTCLOW_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Warn, 3, text, length)

#define NN_DETAIL_HTCLOW_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Error, 0, text, length)
#define NN_DETAIL_HTCLOW_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Error, 1, text, length)
#define NN_DETAIL_HTCLOW_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Error, 2, text, length)
#define NN_DETAIL_HTCLOW_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Error, 3, text, length)

#define NN_DETAIL_HTCLOW_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Fatal, 0, text, length)
#define NN_DETAIL_HTCLOW_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Fatal, 1, text, length)
#define NN_DETAIL_HTCLOW_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Fatal, 2, text, length)
#define NN_DETAIL_HTCLOW_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htclow, Fatal, 3, text, length)
