﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

// フォーマット指定子
#ifdef NN_BUILD_CONFIG_OS_WIN
#define PRId64 "lld"
#define PRIu64 "llu"
#else
#include <cinttypes>
#endif

namespace nn { namespace gc {
namespace detail {

static const size_t GcMmcCmd60DataSize = 64;    // = nn::sdmmc::GcAsicOperationSize だが、これだけのためにヘッダをインクルードするのは避けたい

static const size_t GcAsicFirmwareSize = (30 * 1024);

static const size_t GcRandomValueSize = 32;
static const size_t GcRandomValueForKeyUpdateSocSize = 31;
static const size_t GcRsaOaepSeedSize = 32;

static const size_t GcPaddingU8 = 0xFF;
static const size_t GcCertificateSize = 1024;
static const size_t GcSocModulusOffset = 0x130;

static const int    GcSendCommandMaxCount = 3; // GC のタイムアウト事件を受けて 2->3 に増やした

static const uint64_t UnusedAreaSizeBase = 72 * 1024 * 1024;
static const uint64_t MemorySizeBase     = 1024 * 1024 * 1024;
static const uint64_t AvailableSizeBase     = MemorySizeBase - UnusedAreaSizeBase;

static const uint32_t Cmd60DefaultTimeOutMilliSeconds = 3500; // デフォルトタイムアウトは 3.5s (SIGLO-77971)
static const uint32_t EraseTimeOutMilliSeconds = 10 * 1000; // Erase だけ 10s

// マクロ
#define SDMMC_DETAIL_CEILING(value, unit)   ((((value) + (unit) - 1) / (unit)) * (unit))
#define SDMMC_DETAIL_CEILING_FOR_DEVICE_ADDRESS_SPACE(value)    SDMMC_DETAIL_CEILING((value), nn::dd::DeviceAddressSpaceMemoryRegionAlignment)

#define NN_GC_DETAIL_SELECT_MAX_VALUE(a, b) ((a) > (b) ? (a) : (b))
#define NN_GC_DETAIL_SELECT_MIN_VALUE(a, b) ((a) < (b) ? (a) : (b))

// ログの有効／無効切り替えフラグ
#define GC_DETAIL_ERR_LOG_ENABLE
#define GC_DETAIL_WARNING_LOG_ENABLE

//#define GC_LOG_ENABLE
//#define GC_DETAIL_LOG_ENABLE
//#define GC_DETAIL_DEBUG_LOG_ENABLE
//#define GC_DETAIL_IO_LOG_ENABLE
//#define GC_DETAIL_CRYPTO_LOG_ENABLE
//#define GC_DEBUG_MEMDUMP_ENABLE
//#define GC_DETAIL_LOG_FUNCTION_INDENT_ENABLE

// #define GC_DETAIL_LOG_TO_MEMORY_ENABLE

} } }

