﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/fssystem/save/fs_SaveTypes.h>

namespace nn { namespace fssystem { namespace save {

class IDirectory
{
    NN_DISALLOW_COPY(IDirectory);

public:
    /**
    * @brief        コンストラクタです。
    */
    IDirectory() NN_NOEXCEPT
    {
    }

    /**
    * @brief        デストラクタです。
    */
    virtual ~IDirectory() NN_NOEXCEPT
    {
    }

    /**
    * @brief        ディレクトリ内の子ディレクトリエントリーを取得します。
    *
    * @param[out]   outNumEntries   取得したエントリー数
    * @param[out]   outEntries      取得したエントリー情報
    *                               配列のサイズは numEntries 以上である必要があります。
    * @param[in]    numEntries      取得するエントリー数
    *
    * @return       関数の処理結果を返します。
    */
    virtual Result Read(
                       int32_t* outNumEntries,
                       nn::fs::DirectoryEntry outEntries[],
                       int32_t numEntries
                   ) NN_NOEXCEPT = 0;
};

}}}

