﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fs/fs_Directory.h>

#include <nn/fs/detail/fs_Newable.h>

namespace nn { namespace fssystem {

    class HtcFileSystem : public nn::fs::fsa::IFileSystem, public nn::fs::detail::Newable
    {
    public:
        Result Initialize() NN_NOEXCEPT;

        HtcFileSystem() NN_NOEXCEPT;
        virtual ~HtcFileSystem() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoCreateFile(const char* path, int64_t size, int option) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteFile(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameFile(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoCreateDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCleanDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameDirectory(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoGetEntryType(nn::fs::DirectoryEntryType* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoOpenFile(std::unique_ptr<nn::fs::fsa::IFile>* outValue, const char* path, nn::fs::OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOpenDirectory(std::unique_ptr<nn::fs::fsa::IDirectory>* outValue, const char* path, nn::fs::OpenDirectoryMode mode) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoGetFileTimeStampRaw(nn::fs::FileTimeStampRaw* outTimeStamp, const char* path) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoCommit() NN_NOEXCEPT NN_OVERRIDE;
    };

}}
