﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include<nn/nn_Common.h>
#include<nn/util/util_BitUtil.h>

namespace nn { namespace fssystem { namespace dbm {

/**
* @brief        fssystem 内から呼び出される関数群。
*
* @details      fssystem 内から呼び出される関数群。
*/
namespace
{
    /**
    * @brief        MSB から 0 が連続している回数を取得します。
    *
    * @param[in]    bits        ビット列
    *
    * @return       ビット数。
    *
    * @details      MSB から 0 が連続している回数を取得します。
    */
    inline int CountLeadingZeros(uint32_t bits) NN_NOEXCEPT
    {
        return nn::util::cntl0(bits);
    }

    /**
    * @brief        MSB から 1 が連続している回数を取得します。
    *
    * @param[in]    bits        ビット列
    *
    * @return       ビット数。
    *
    * @details      MSB から 1 が連続している回数を取得します。
    */
    inline int CountLeadingOnes(uint32_t bits) NN_NOEXCEPT
    {
        return CountLeadingZeros(~bits);
    }

    /**
    * @brief        配列の指定したインデックスから 32bit 値を取得します。
    *
    * @param[in]    buffer      配列
    * @param[in]    index       インデックス
    *
    * @return       取得した 32bit 値。
    *
    * @details      配列の指定したインデックスから 32bit 値を取得します。
    */
    inline uint32_t ReadU32(const uint8_t* buffer, size_t index) NN_NOEXCEPT
    {
        uint32_t value;
        memcpy(&value, buffer + index, sizeof(uint32_t));
        return value;
    }

    /**
    * @brief        配列の指定したインデックスから 32bit 値を設定します。
    *
    * @param[in]    buffer      配列
    * @param[in]    index       インデックス
    * @param[in]    value       設定する値
    *
    * @details      配列の指定したインデックスから 32bit 値を設定します。
    */
    inline void WriteU32(uint8_t* buffer, size_t index, uint32_t value) NN_NOEXCEPT
    {
        memcpy(buffer + index, &value, sizeof(uint32_t));
    }
}

}}}

