﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/fs/fs_ErrorInfoPrivate.h>
#include <nn/fs/fs_MemoryReportInfo.h>
#include <nn/fs/fs_RightsId.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/fs_SdCardPrivate.h>
#include <nn/fssrv/sf/fssrv_IDeviceOperator.h>
#include <nn/fssrv/sf/fssrv_IEventNotifier.h>
#include <nn/fssrv/sf/fssrv_IFile.h>
#include <nn/fssrv/sf/fssrv_IFileSystem.h>
#include <nn/fssrv/sf/fssrv_IMultiCommitManager.h>
#include <nn/fssrv/sf/fssrv_ISaveDataInfoReader.h>
#include <nn/fssrv/sf/fssrv_ISaveDataTransfer.h>
#include <nn/fssrv/sf/fssrv_IStorage.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_DataId.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/spl/spl_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace fssrv { namespace sf { // NOLINT(whitespace/braces)

struct FspPath;

class IFileSystemProxy;

struct FspPath
{
    char str[769];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFileSystemProxy, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFileSystemProxy)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentProcess, (::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataFileSystemByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenFileSystemWithPatch, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenFileSystemWithId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::nn::Bit64 programId, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataFileSystemByProgramId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenBisFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::std::uint32_t id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenBisStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(InvalidateBisCache)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenHostFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSdCardFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCardFileSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystem, (::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystem, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemBySystemSaveDataId, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSaveDataFileSystemAtomicDeletion, (const ::nn::sf::InBuffer& saveDataIdArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCardDryRun)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsExFatSupported, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataAttribute, (::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t handle, ::std::uint32_t partition))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t handle, ::std::uint32_t partition))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtendSaveDataFileSystem, (::std::uint8_t spaceId, ::std::uint64_t saveDataId, ::std::int64_t saveDataAvailableSize, ::std::int64_t saveDataJournalSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteCacheStorage, (::std::uint16_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCacheStorageSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outJournalSize, ::std::uint16_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemWithHashSalt, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo, const ::nn::fs::HashSalt& salt))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystemBySystemSaveDataId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenReadOnlySaveDataFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId, (const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraData, (const ::nn::sf::OutBuffer& buffer, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraData, (::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReader, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderBySaveDataSpaceId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderOnlyCacheStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInternalStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateSaveDataMacForDebug, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraDataWithMask, (::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& extraDataValue, const ::nn::sf::InBuffer& extraDataMask))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindSaveDataWithFilter, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderWithFilter, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataMetaFile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute, ::std::uint32_t metaType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManager>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManagerVersion2, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferProhibiter, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAccessibleSaveDataOwnerId, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ProgramId programId, ::std::int32_t offset, ::std::int32_t count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenImageDirectoryFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenCloudBackupWorkStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByProgramId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::ProgramId programId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByDataId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::DataId dataId, ::nn::Bit8 storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenPatchDataStorageByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDeviceOperator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDeviceOperator>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSdCardDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSystemDataUpdateEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifySystemDataUpdateEvent)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SimulateDeviceDetectionEvent, (::std::uint32_t deviceType, ::std::uint32_t detectionEventType, bool isWithEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QuerySaveDataTotalSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::int64_t saveDataSize, ::std::int64_t saveDataJournalSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystem, (::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystem, (::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreatePaddingFile, (::std::int64_t paddingSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPaddingFiles)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsId, (::nn::sf::Out<::nn::fs::RightsId> outValue, ::nn::ncm::ProgramId programId, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterExternalKey, (const ::nn::fs::RightsId& rightsId, const ::nn::spl::AccessKey& accessKey))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllExternalKey)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsIdByPath, (::nn::sf::Out<::nn::fs::RightsId> outValue, const ::nn::fssrv::sf::FspPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsIdAndKeyGenerationByPath, (::nn::sf::Out<::nn::fs::RightsId> outRightsId, ::nn::sf::Out<::std::uint8_t> outKeyGeneration, const ::nn::fssrv::sf::FspPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentPosixTimeWithTimeDifference, (::std::int64_t posixTime, ::std::int32_t timeDifference))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSizeForSaveData, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QuerySaveDataInternalStorageTotalSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSaveDataCommitId, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSdCardEncryptionSeed, (const ::nn::fs::EncryptionSeed& seed))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSdCardAccessibility, (bool isAccessible))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSdCardAccessible, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSignedSystemPartitionOnSdCardValid, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessFailureDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccessFailureDetectionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAccessFailureDetected, (::nn::sf::Out<bool> outValue, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResolveAccessFailure, (::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AbandonAccessFailure, (::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearErrorInfo, (::nn::sf::Out<::nn::fs::FileSystemProxyErrorInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBisRootForHost, (::std::uint32_t id, const ::nn::fssrv::sf::FspPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSaveDataSize, (::std::int64_t size, ::std::int64_t journalSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSaveDataRootPath, (const ::nn::fssrv::sf::FspPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableAutoSaveDataCreation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetGlobalAccessLogMode, (::std::uint32_t accessLogMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGlobalAccessLogMode, (::nn::sf::Out<::std::uint32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OutputAccessLogToSdCard, (const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RegisterUpdatePartition)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenRegisteredUpdatePartition, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearMemoryReportInfo, (::nn::sf::Out<::nn::fs::MemoryReportInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDataStorageRedirectTarget, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OverrideSaveDataTransferTokenSignVerificationKey, (const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenMultiCommitManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IMultiCommitManager>> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFileSystemProxy)

        ::nn::Result SetCurrentProcess(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetCurrentProcess, (processId));
        }

        ::nn::Result OpenDataFileSystemByCurrentProcess(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDataFileSystemByCurrentProcess, (outValue));
        }

        ::nn::Result OpenFileSystemWithPatch(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenFileSystemWithPatch, (outValue, programId, type));
        }

        ::nn::Result OpenFileSystemWithId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::nn::Bit64 programId, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenFileSystemWithId, (outValue, path, programId, type));
        }

        ::nn::Result OpenDataFileSystemByProgramId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDataFileSystemByProgramId, (outValue, programId));
        }

        ::nn::Result OpenBisFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::std::uint32_t id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenBisFileSystem, (outValue, path, id));
        }

        ::nn::Result OpenBisStorage(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenBisStorage, (outValue, id));
        }

        ::nn::Result InvalidateBisCache() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(InvalidateBisCache);
        }

        ::nn::Result OpenHostFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenHostFileSystem, (outValue, path));
        }

        ::nn::Result OpenSdCardFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSdCardFileSystem, (outValue));
        }

        ::nn::Result FormatSdCardFileSystem() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FormatSdCardFileSystem);
        }

        ::nn::Result DeleteSaveDataFileSystem(::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystem, (saveDataId));
        }

        ::nn::Result CreateSaveDataFileSystem(const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystem, (attribute, creationInfo, metaInfo));
        }

        ::nn::Result CreateSaveDataFileSystemBySystemSaveDataId(const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemBySystemSaveDataId, (attribute, creationInfo));
        }

        ::nn::Result RegisterSaveDataFileSystemAtomicDeletion(const ::nn::sf::InBuffer& saveDataIdArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterSaveDataFileSystemAtomicDeletion, (saveDataIdArray));
        }

        ::nn::Result DeleteSaveDataFileSystemBySaveDataSpaceId(::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataSpaceId, (saveDataSpaceId, saveDataId));
        }

        ::nn::Result FormatSdCardDryRun() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FormatSdCardDryRun);
        }

        ::nn::Result IsExFatSupported(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsExFatSupported, (outValue));
        }

        ::nn::Result DeleteSaveDataFileSystemBySaveDataAttribute(::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataAttribute, (saveDataSpaceId, attribute));
        }

        ::nn::Result OpenGameCardStorage(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t handle, ::std::uint32_t partition) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenGameCardStorage, (outValue, handle, partition));
        }

        ::nn::Result OpenGameCardFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t handle, ::std::uint32_t partition) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenGameCardFileSystem, (outValue, handle, partition));
        }

        ::nn::Result ExtendSaveDataFileSystem(::std::uint8_t spaceId, ::std::uint64_t saveDataId, ::std::int64_t saveDataAvailableSize, ::std::int64_t saveDataJournalSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtendSaveDataFileSystem, (spaceId, saveDataId, saveDataAvailableSize, saveDataJournalSize));
        }

        ::nn::Result DeleteCacheStorage(::std::uint16_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteCacheStorage, (index));
        }

        ::nn::Result GetCacheStorageSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outJournalSize, ::std::uint16_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCacheStorageSize, (outSize, outJournalSize, index));
        }

        ::nn::Result CreateSaveDataFileSystemWithHashSalt(const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo, const ::nn::fs::HashSalt& salt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemWithHashSalt, (attribute, creationInfo, metaInfo, salt));
        }

        ::nn::Result OpenSaveDataFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystem, (outValue, saveDataSpaceId, attribute));
        }

        ::nn::Result OpenSaveDataFileSystemBySystemSaveDataId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystemBySystemSaveDataId, (outValue, saveDataSpaceId, attribute));
        }

        ::nn::Result OpenReadOnlySaveDataFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenReadOnlySaveDataFileSystem, (outValue, saveDataSpaceId, attribute));
        }

        ::nn::Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId, (buffer, saveDataSpaceId, saveDataId));
        }

        ::nn::Result ReadSaveDataFileSystemExtraData(const ::nn::sf::OutBuffer& buffer, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraData, (buffer, saveDataId));
        }

        ::nn::Result WriteSaveDataFileSystemExtraData(::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraData, (saveDataId, saveDataSpaceId, buffer));
        }

        ::nn::Result OpenSaveDataInfoReader(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReader, (outValue));
        }

        ::nn::Result OpenSaveDataInfoReaderBySaveDataSpaceId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderBySaveDataSpaceId, (outValue, saveDataSpaceId));
        }

        ::nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderOnlyCacheStorage, (outValue));
        }

        ::nn::Result OpenSaveDataInternalStorageFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataInternalStorageFileSystem, (outValue, saveDataSpaceId, saveDataId));
        }

        ::nn::Result UpdateSaveDataMacForDebug(::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateSaveDataMacForDebug, (saveDataSpaceId, saveDataId));
        }

        ::nn::Result WriteSaveDataFileSystemExtraDataWithMask(::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& extraDataValue, const ::nn::sf::InBuffer& extraDataMask) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraDataWithMask, (saveDataId, saveDataSpaceId, extraDataValue, extraDataMask));
        }

        ::nn::Result FindSaveDataWithFilter(::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindSaveDataWithFilter, (outValue, buffer, saveDataSpaceId, filter));
        }

        ::nn::Result OpenSaveDataInfoReaderWithFilter(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderWithFilter, (outValue, saveDataSpaceId, filter));
        }

        ::nn::Result OpenSaveDataMetaFile(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute, ::std::uint32_t metaType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataMetaFile, (outValue, saveDataSpaceId, attribute, metaType));
        }

        ::nn::Result OpenSaveDataTransferManager(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManager>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManager, (outValue));
        }

        ::nn::Result OpenSaveDataTransferManagerVersion2(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManagerVersion2, (outValue));
        }

        ::nn::Result OpenSaveDataTransferProhibiter(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSaveDataTransferProhibiter, (outValue, applicationId));
        }

        ::nn::Result ListAccessibleSaveDataOwnerId(::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ProgramId programId, ::std::int32_t offset, ::std::int32_t count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAccessibleSaveDataOwnerId, (outValue, outBuffer, programId, offset, count));
        }

        ::nn::Result OpenImageDirectoryFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenImageDirectoryFileSystem, (outValue, storageId));
        }

        ::nn::Result OpenContentStorageFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenContentStorageFileSystem, (outValue, storageId));
        }

        ::nn::Result OpenCloudBackupWorkStorageFileSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenCloudBackupWorkStorageFileSystem, (outValue, storageId));
        }

        ::nn::Result OpenDataStorageByCurrentProcess(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDataStorageByCurrentProcess, (outValue));
        }

        ::nn::Result OpenDataStorageByProgramId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::ProgramId programId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDataStorageByProgramId, (outValue, programId));
        }

        ::nn::Result OpenDataStorageByDataId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::DataId dataId, ::nn::Bit8 storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDataStorageByDataId, (outValue, dataId, storageId));
        }

        ::nn::Result OpenPatchDataStorageByCurrentProcess(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenPatchDataStorageByCurrentProcess, (outValue));
        }

        ::nn::Result OpenDeviceOperator(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDeviceOperator>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDeviceOperator, (outValue));
        }

        ::nn::Result OpenSdCardDetectionEventNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSdCardDetectionEventNotifier, (outValue));
        }

        ::nn::Result OpenGameCardDetectionEventNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenGameCardDetectionEventNotifier, (outValue));
        }

        ::nn::Result OpenSystemDataUpdateEventNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSystemDataUpdateEventNotifier, (outValue));
        }

        ::nn::Result NotifySystemDataUpdateEvent() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifySystemDataUpdateEvent);
        }

        ::nn::Result SimulateDeviceDetectionEvent(::std::uint32_t deviceType, ::std::uint32_t detectionEventType, bool isWithEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SimulateDeviceDetectionEvent, (deviceType, detectionEventType, isWithEvent));
        }

        ::nn::Result QuerySaveDataTotalSize(::nn::sf::Out<::std::int64_t> outValue, ::std::int64_t saveDataSize, ::std::int64_t saveDataJournalSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QuerySaveDataTotalSize, (outValue, saveDataSize, saveDataJournalSize));
        }

        ::nn::Result VerifySaveDataFileSystem(::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystem, (saveDataId, buffer));
        }

        ::nn::Result CorruptSaveDataFileSystem(::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystem, (saveDataId));
        }

        ::nn::Result CreatePaddingFile(::std::int64_t paddingSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreatePaddingFile, (paddingSize));
        }

        ::nn::Result DeleteAllPaddingFiles() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteAllPaddingFiles);
        }

        ::nn::Result GetRightsId(::nn::sf::Out<::nn::fs::RightsId> outValue, ::nn::ncm::ProgramId programId, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRightsId, (outValue, programId, storageId));
        }

        ::nn::Result RegisterExternalKey(const ::nn::fs::RightsId& rightsId, const ::nn::spl::AccessKey& accessKey) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterExternalKey, (rightsId, accessKey));
        }

        ::nn::Result UnregisterAllExternalKey() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnregisterAllExternalKey);
        }

        ::nn::Result GetRightsIdByPath(::nn::sf::Out<::nn::fs::RightsId> outValue, const ::nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRightsIdByPath, (outValue, path));
        }

        ::nn::Result GetRightsIdAndKeyGenerationByPath(::nn::sf::Out<::nn::fs::RightsId> outRightsId, ::nn::sf::Out<::std::uint8_t> outKeyGeneration, const ::nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRightsIdAndKeyGenerationByPath, (outRightsId, outKeyGeneration, path));
        }

        ::nn::Result SetCurrentPosixTimeWithTimeDifference(::std::int64_t posixTime, ::std::int32_t timeDifference) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetCurrentPosixTimeWithTimeDifference, (posixTime, timeDifference));
        }

        ::nn::Result GetFreeSpaceSizeForSaveData(::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFreeSpaceSizeForSaveData, (outValue, saveDataSpaceId));
        }

        ::nn::Result VerifySaveDataFileSystemBySaveDataSpaceId(::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystemBySaveDataSpaceId, (saveDataSpaceId, saveDataId, buffer));
        }

        ::nn::Result CorruptSaveDataFileSystemBySaveDataSpaceId(::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystemBySaveDataSpaceId, (saveDataSpaceId, saveDataId));
        }

        ::nn::Result QuerySaveDataInternalStorageTotalSize(::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QuerySaveDataInternalStorageTotalSize, (outValue, saveDataSpaceId, saveDataId));
        }

        ::nn::Result GetSaveDataCommitId(::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSaveDataCommitId, (outValue, saveDataSpaceId, saveDataId));
        }

        ::nn::Result SetSdCardEncryptionSeed(const ::nn::fs::EncryptionSeed& seed) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSdCardEncryptionSeed, (seed));
        }

        ::nn::Result SetSdCardAccessibility(bool isAccessible) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSdCardAccessibility, (isAccessible));
        }

        ::nn::Result IsSdCardAccessible(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSdCardAccessible, (outValue));
        }

        ::nn::Result IsSignedSystemPartitionOnSdCardValid(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSignedSystemPartitionOnSdCardValid, (outValue));
        }

        ::nn::Result OpenAccessFailureDetectionEventNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAccessFailureDetectionEventNotifier, (outValue, processId));
        }

        ::nn::Result GetAccessFailureDetectionEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccessFailureDetectionEvent, (outValue));
        }

        ::nn::Result IsAccessFailureDetected(::nn::sf::Out<bool> outValue, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAccessFailureDetected, (outValue, processId));
        }

        ::nn::Result ResolveAccessFailure(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResolveAccessFailure, (processId));
        }

        ::nn::Result AbandonAccessFailure(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AbandonAccessFailure, (processId));
        }

        ::nn::Result GetAndClearErrorInfo(::nn::sf::Out<::nn::fs::FileSystemProxyErrorInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAndClearErrorInfo, (outValue));
        }

        ::nn::Result SetBisRootForHost(::std::uint32_t id, const ::nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBisRootForHost, (id, path));
        }

        ::nn::Result SetSaveDataSize(::std::int64_t size, ::std::int64_t journalSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSaveDataSize, (size, journalSize));
        }

        ::nn::Result SetSaveDataRootPath(const ::nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSaveDataRootPath, (path));
        }

        ::nn::Result DisableAutoSaveDataCreation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableAutoSaveDataCreation);
        }

        ::nn::Result SetGlobalAccessLogMode(::std::uint32_t accessLogMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetGlobalAccessLogMode, (accessLogMode));
        }

        ::nn::Result GetGlobalAccessLogMode(::nn::sf::Out<::std::uint32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGlobalAccessLogMode, (outValue));
        }

        ::nn::Result OutputAccessLogToSdCard(const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OutputAccessLogToSdCard, (buffer));
        }

        ::nn::Result RegisterUpdatePartition() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RegisterUpdatePartition);
        }

        ::nn::Result OpenRegisteredUpdatePartition(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenRegisteredUpdatePartition, (outValue));
        }

        ::nn::Result GetAndClearMemoryReportInfo(::nn::sf::Out<::nn::fs::MemoryReportInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAndClearMemoryReportInfo, (outValue));
        }

        ::nn::Result SetDataStorageRedirectTarget(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDataStorageRedirectTarget, (storageId));
        }

        ::nn::Result OverrideSaveDataTransferTokenSignVerificationKey(const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OverrideSaveDataTransferTokenSignVerificationKey, (buffer));
        }

        ::nn::Result OpenMultiCommitManager(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IMultiCommitManager>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenMultiCommitManager, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFileSystemProxy
    {
    public:
        nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result OpenDataFileSystemByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
        nn::Result OpenFileSystemWithPatch(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result OpenFileSystemWithId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::Bit64 programId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result OpenDataFileSystemByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result OpenBisFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, std::uint32_t id) NN_NOEXCEPT;
        nn::Result OpenBisStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t id) NN_NOEXCEPT;
        nn::Result InvalidateBisCache() NN_NOEXCEPT;
        nn::Result OpenHostFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result OpenSdCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
        nn::Result FormatSdCardFileSystem() NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystem(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystemBySystemSaveDataId(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo) NN_NOEXCEPT;
        nn::Result RegisterSaveDataFileSystemAtomicDeletion(const nn::sf::InBuffer& saveDataIdArray) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result FormatSdCardDryRun() NN_NOEXCEPT;
        nn::Result IsExFatSupported(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystemBySaveDataAttribute(std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result OpenGameCardStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT;
        nn::Result OpenGameCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT;
        nn::Result ExtendSaveDataFileSystem(std::uint8_t spaceId, std::uint64_t saveDataId, std::int64_t saveDataAvailableSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT;
        nn::Result DeleteCacheStorage(std::uint16_t index) NN_NOEXCEPT;
        nn::Result GetCacheStorageSize(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outJournalSize, std::uint16_t index) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystemWithHashSalt(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::HashSalt& salt) NN_NOEXCEPT;
        nn::Result OpenSaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result OpenSaveDataFileSystemBySystemSaveDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result OpenReadOnlySaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result ReadSaveDataFileSystemExtraData(const nn::sf::OutBuffer& buffer, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result WriteSaveDataFileSystemExtraData(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReader(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderBySaveDataSpaceId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataInternalStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result UpdateSaveDataMacForDebug(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result WriteSaveDataFileSystemExtraDataWithMask(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& extraDataValue, const nn::sf::InBuffer& extraDataMask) NN_NOEXCEPT;
        nn::Result FindSaveDataWithFilter(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderWithFilter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT;
        nn::Result OpenSaveDataMetaFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, std::uint32_t metaType) NN_NOEXCEPT;
        nn::Result OpenSaveDataTransferManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManager>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataTransferManagerVersion2(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataTransferProhibiter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result ListAccessibleSaveDataOwnerId(nn::sf::Out<std::int32_t> outValue, const nn::sf::OutBuffer& outBuffer, nn::ncm::ProgramId programId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT;
        nn::Result OpenImageDirectoryFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
        nn::Result OpenContentStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
        nn::Result OpenCloudBackupWorkStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
        nn::Result OpenDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT;
        nn::Result OpenDataStorageByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result OpenDataStorageByDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::DataId dataId, nn::Bit8 storageId) NN_NOEXCEPT;
        nn::Result OpenPatchDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT;
        nn::Result OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>> outValue) NN_NOEXCEPT;
        nn::Result OpenSdCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
        nn::Result OpenGameCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
        nn::Result OpenSystemDataUpdateEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
        nn::Result NotifySystemDataUpdateEvent() NN_NOEXCEPT;
        nn::Result SimulateDeviceDetectionEvent(std::uint32_t deviceType, std::uint32_t detectionEventType, bool isWithEvent) NN_NOEXCEPT;
        nn::Result QuerySaveDataTotalSize(nn::sf::Out<std::int64_t> outValue, std::int64_t saveDataSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT;
        nn::Result VerifySaveDataFileSystem(std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result CorruptSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result CreatePaddingFile(std::int64_t paddingSize) NN_NOEXCEPT;
        nn::Result DeleteAllPaddingFiles() NN_NOEXCEPT;
        nn::Result GetRightsId(nn::sf::Out<nn::fs::RightsId> outValue, nn::ncm::ProgramId programId, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result RegisterExternalKey(const nn::fs::RightsId& rightsId, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
        nn::Result UnregisterAllExternalKey() NN_NOEXCEPT;
        nn::Result GetRightsIdByPath(nn::sf::Out<nn::fs::RightsId> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result GetRightsIdAndKeyGenerationByPath(nn::sf::Out<nn::fs::RightsId> outRightsId, nn::sf::Out<std::uint8_t> outKeyGeneration, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result SetCurrentPosixTimeWithTimeDifference(std::int64_t posixTime, std::int32_t timeDifference) NN_NOEXCEPT;
        nn::Result GetFreeSpaceSizeForSaveData(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;
        nn::Result VerifySaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result CorruptSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result QuerySaveDataInternalStorageTotalSize(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result GetSaveDataCommitId(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result SetSdCardEncryptionSeed(const nn::fs::EncryptionSeed& seed) NN_NOEXCEPT;
        nn::Result SetSdCardAccessibility(bool isAccessible) NN_NOEXCEPT;
        nn::Result IsSdCardAccessible(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result IsSignedSystemPartitionOnSdCardValid(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result OpenAccessFailureDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetAccessFailureDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result IsAccessFailureDetected(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result ResolveAccessFailure(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result AbandonAccessFailure(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetAndClearErrorInfo(nn::sf::Out<nn::fs::FileSystemProxyErrorInfo> outValue) NN_NOEXCEPT;
        nn::Result SetBisRootForHost(std::uint32_t id, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result SetSaveDataSize(std::int64_t size, std::int64_t journalSize) NN_NOEXCEPT;
        nn::Result SetSaveDataRootPath(const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result DisableAutoSaveDataCreation() NN_NOEXCEPT;
        nn::Result SetGlobalAccessLogMode(std::uint32_t accessLogMode) NN_NOEXCEPT;
        nn::Result GetGlobalAccessLogMode(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
        nn::Result OutputAccessLogToSdCard(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result RegisterUpdatePartition() NN_NOEXCEPT;
        nn::Result OpenRegisteredUpdatePartition(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
        nn::Result GetAndClearMemoryReportInfo(nn::sf::Out<nn::fs::MemoryReportInfo> outValue) NN_NOEXCEPT;
        nn::Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result OverrideSaveDataTransferTokenSignVerificationKey(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result OpenMultiCommitManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IMultiCommitManager>> outValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result OpenDataFileSystemByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
    nn::Result OpenFileSystemWithPatch(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId, std::uint32_t type) NN_NOEXCEPT;
    nn::Result OpenFileSystemWithId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::Bit64 programId, std::uint32_t type) NN_NOEXCEPT;
    nn::Result OpenDataFileSystemByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT;
    nn::Result OpenBisFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, std::uint32_t id) NN_NOEXCEPT;
    nn::Result OpenBisStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t id) NN_NOEXCEPT;
    nn::Result InvalidateBisCache() NN_NOEXCEPT;
    nn::Result OpenHostFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
    nn::Result OpenSdCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
    nn::Result FormatSdCardFileSystem() NN_NOEXCEPT;
    nn::Result DeleteSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result CreateSaveDataFileSystem(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo) NN_NOEXCEPT;
    nn::Result CreateSaveDataFileSystemBySystemSaveDataId(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo) NN_NOEXCEPT;
    nn::Result RegisterSaveDataFileSystemAtomicDeletion(const nn::sf::InBuffer& saveDataIdArray) NN_NOEXCEPT;
    nn::Result DeleteSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result FormatSdCardDryRun() NN_NOEXCEPT;
    nn::Result IsExFatSupported(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result DeleteSaveDataFileSystemBySaveDataAttribute(std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
    nn::Result OpenGameCardStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT;
    nn::Result OpenGameCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT;
    nn::Result ExtendSaveDataFileSystem(std::uint8_t spaceId, std::uint64_t saveDataId, std::int64_t saveDataAvailableSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT;
    nn::Result DeleteCacheStorage(std::uint16_t index) NN_NOEXCEPT;
    nn::Result GetCacheStorageSize(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outJournalSize, std::uint16_t index) NN_NOEXCEPT;
    nn::Result CreateSaveDataFileSystemWithHashSalt(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::HashSalt& salt) NN_NOEXCEPT;
    nn::Result OpenSaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
    nn::Result OpenSaveDataFileSystemBySystemSaveDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
    nn::Result OpenReadOnlySaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
    nn::Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result ReadSaveDataFileSystemExtraData(const nn::sf::OutBuffer& buffer, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result WriteSaveDataFileSystemExtraData(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result OpenSaveDataInfoReader(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT;
    nn::Result OpenSaveDataInfoReaderBySaveDataSpaceId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;
    nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT;
    nn::Result OpenSaveDataInternalStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result UpdateSaveDataMacForDebug(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result WriteSaveDataFileSystemExtraDataWithMask(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& extraDataValue, const nn::sf::InBuffer& extraDataMask) NN_NOEXCEPT;
    nn::Result FindSaveDataWithFilter(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT;
    nn::Result OpenSaveDataInfoReaderWithFilter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT;
    nn::Result OpenSaveDataMetaFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, std::uint32_t metaType) NN_NOEXCEPT;
    nn::Result OpenSaveDataTransferManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManager>> outValue) NN_NOEXCEPT;
    nn::Result OpenSaveDataTransferManagerVersion2(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue) NN_NOEXCEPT;
    nn::Result OpenSaveDataTransferProhibiter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result ListAccessibleSaveDataOwnerId(nn::sf::Out<std::int32_t> outValue, const nn::sf::OutBuffer& outBuffer, nn::ncm::ProgramId programId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT;
    nn::Result OpenImageDirectoryFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
    nn::Result OpenContentStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
    nn::Result OpenCloudBackupWorkStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
    nn::Result OpenDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT;
    nn::Result OpenDataStorageByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT;
    nn::Result OpenDataStorageByDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::DataId dataId, nn::Bit8 storageId) NN_NOEXCEPT;
    nn::Result OpenPatchDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT;
    nn::Result OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>> outValue) NN_NOEXCEPT;
    nn::Result OpenSdCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
    nn::Result OpenGameCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
    nn::Result OpenSystemDataUpdateEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
    nn::Result NotifySystemDataUpdateEvent() NN_NOEXCEPT;
    nn::Result SimulateDeviceDetectionEvent(std::uint32_t deviceType, std::uint32_t detectionEventType, bool isWithEvent) NN_NOEXCEPT;
    nn::Result QuerySaveDataTotalSize(nn::sf::Out<std::int64_t> outValue, std::int64_t saveDataSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT;
    nn::Result VerifySaveDataFileSystem(std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result CorruptSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result CreatePaddingFile(std::int64_t paddingSize) NN_NOEXCEPT;
    nn::Result DeleteAllPaddingFiles() NN_NOEXCEPT;
    nn::Result GetRightsId(nn::sf::Out<nn::fs::RightsId> outValue, nn::ncm::ProgramId programId, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result RegisterExternalKey(const nn::fs::RightsId& rightsId, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
    nn::Result UnregisterAllExternalKey() NN_NOEXCEPT;
    nn::Result GetRightsIdByPath(nn::sf::Out<nn::fs::RightsId> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
    nn::Result GetRightsIdAndKeyGenerationByPath(nn::sf::Out<nn::fs::RightsId> outRightsId, nn::sf::Out<std::uint8_t> outKeyGeneration, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
    nn::Result SetCurrentPosixTimeWithTimeDifference(std::int64_t posixTime, std::int32_t timeDifference) NN_NOEXCEPT;
    nn::Result GetFreeSpaceSizeForSaveData(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;
    nn::Result VerifySaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result CorruptSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result QuerySaveDataInternalStorageTotalSize(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result GetSaveDataCommitId(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
    nn::Result SetSdCardEncryptionSeed(const nn::fs::EncryptionSeed& seed) NN_NOEXCEPT;
    nn::Result SetSdCardAccessibility(bool isAccessible) NN_NOEXCEPT;
    nn::Result IsSdCardAccessible(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result IsSignedSystemPartitionOnSdCardValid(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result OpenAccessFailureDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetAccessFailureDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result IsAccessFailureDetected(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result ResolveAccessFailure(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result AbandonAccessFailure(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetAndClearErrorInfo(nn::sf::Out<nn::fs::FileSystemProxyErrorInfo> outValue) NN_NOEXCEPT;
    nn::Result SetBisRootForHost(std::uint32_t id, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
    nn::Result SetSaveDataSize(std::int64_t size, std::int64_t journalSize) NN_NOEXCEPT;
    nn::Result SetSaveDataRootPath(const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
    nn::Result DisableAutoSaveDataCreation() NN_NOEXCEPT;
    nn::Result SetGlobalAccessLogMode(std::uint32_t accessLogMode) NN_NOEXCEPT;
    nn::Result GetGlobalAccessLogMode(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
    nn::Result OutputAccessLogToSdCard(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result RegisterUpdatePartition() NN_NOEXCEPT;
    nn::Result OpenRegisteredUpdatePartition(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
    nn::Result GetAndClearMemoryReportInfo(nn::sf::Out<nn::fs::MemoryReportInfo> outValue) NN_NOEXCEPT;
    nn::Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result OverrideSaveDataTransferTokenSignVerificationKey(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result OpenMultiCommitManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IMultiCommitManager>> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::fssrv::sf::IFileSystemProxy))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentProcess, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetCurrentProcess, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataFileSystemByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDataFileSystemByCurrentProcess, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenFileSystemWithPatch, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenFileSystemWithPatch, (outValue, programId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenFileSystemWithId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::nn::Bit64 programId, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenFileSystemWithId, (outValue, path, programId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataFileSystemByProgramId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDataFileSystemByProgramId, (outValue, programId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenBisFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::std::uint32_t id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenBisFileSystem, (outValue, path, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenBisStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenBisStorage, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InvalidateBisCache)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(InvalidateBisCache);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenHostFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenHostFileSystem, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSdCardFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSdCardFileSystem, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCardFileSystem)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FormatSdCardFileSystem);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystem, (::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteSaveDataFileSystem, (saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystem, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSaveDataFileSystem, (attribute, creationInfo, metaInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemBySystemSaveDataId, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSaveDataFileSystemBySystemSaveDataId, (attribute, creationInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSaveDataFileSystemAtomicDeletion, (const ::nn::sf::InBuffer& saveDataIdArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterSaveDataFileSystemAtomicDeletion, (saveDataIdArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataSpaceId, (saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCardDryRun)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FormatSdCardDryRun);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsExFatSupported, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsExFatSupported, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataAttribute, (::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataAttribute, (saveDataSpaceId, attribute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t handle, ::std::uint32_t partition))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenGameCardStorage, (outValue, handle, partition));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t handle, ::std::uint32_t partition))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenGameCardFileSystem, (outValue, handle, partition));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtendSaveDataFileSystem, (::std::uint8_t spaceId, ::std::uint64_t saveDataId, ::std::int64_t saveDataAvailableSize, ::std::int64_t saveDataJournalSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtendSaveDataFileSystem, (spaceId, saveDataId, saveDataAvailableSize, saveDataJournalSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteCacheStorage, (::std::uint16_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteCacheStorage, (index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCacheStorageSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outJournalSize, ::std::uint16_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCacheStorageSize, (outSize, outJournalSize, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemWithHashSalt, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo, const ::nn::fs::HashSalt& salt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSaveDataFileSystemWithHashSalt, (attribute, creationInfo, metaInfo, salt));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataFileSystem, (outValue, saveDataSpaceId, attribute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystemBySystemSaveDataId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataFileSystemBySystemSaveDataId, (outValue, saveDataSpaceId, attribute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenReadOnlySaveDataFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenReadOnlySaveDataFileSystem, (outValue, saveDataSpaceId, attribute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId, (const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId, (buffer, saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraData, (const ::nn::sf::OutBuffer& buffer, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadSaveDataFileSystemExtraData, (buffer, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraData, (::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteSaveDataFileSystemExtraData, (saveDataId, saveDataSpaceId, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReader, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataInfoReader, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderBySaveDataSpaceId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataInfoReaderBySaveDataSpaceId, (outValue, saveDataSpaceId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderOnlyCacheStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataInfoReaderOnlyCacheStorage, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInternalStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataInternalStorageFileSystem, (outValue, saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateSaveDataMacForDebug, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateSaveDataMacForDebug, (saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraDataWithMask, (::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& extraDataValue, const ::nn::sf::InBuffer& extraDataMask))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteSaveDataFileSystemExtraDataWithMask, (saveDataId, saveDataSpaceId, extraDataValue, extraDataMask));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindSaveDataWithFilter, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindSaveDataWithFilter, (outValue, buffer, saveDataSpaceId, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderWithFilter, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataInfoReaderWithFilter, (outValue, saveDataSpaceId, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataMetaFile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute, ::std::uint32_t metaType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataMetaFile, (outValue, saveDataSpaceId, attribute, metaType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManager>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataTransferManager, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManagerVersion2, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataTransferManagerVersion2, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferProhibiter, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSaveDataTransferProhibiter, (outValue, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAccessibleSaveDataOwnerId, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ProgramId programId, ::std::int32_t offset, ::std::int32_t count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAccessibleSaveDataOwnerId, (outValue, outBuffer, programId, offset, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenImageDirectoryFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenImageDirectoryFileSystem, (outValue, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenContentStorageFileSystem, (outValue, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenCloudBackupWorkStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenCloudBackupWorkStorageFileSystem, (outValue, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDataStorageByCurrentProcess, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByProgramId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::ProgramId programId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDataStorageByProgramId, (outValue, programId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByDataId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::DataId dataId, ::nn::Bit8 storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDataStorageByDataId, (outValue, dataId, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenPatchDataStorageByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenPatchDataStorageByCurrentProcess, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDeviceOperator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDeviceOperator>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDeviceOperator, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSdCardDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSdCardDetectionEventNotifier, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenGameCardDetectionEventNotifier, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSystemDataUpdateEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSystemDataUpdateEventNotifier, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifySystemDataUpdateEvent)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifySystemDataUpdateEvent);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SimulateDeviceDetectionEvent, (::std::uint32_t deviceType, ::std::uint32_t detectionEventType, bool isWithEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SimulateDeviceDetectionEvent, (deviceType, detectionEventType, isWithEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QuerySaveDataTotalSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::int64_t saveDataSize, ::std::int64_t saveDataJournalSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QuerySaveDataTotalSize, (outValue, saveDataSize, saveDataJournalSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystem, (::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifySaveDataFileSystem, (saveDataId, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystem, (::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CorruptSaveDataFileSystem, (saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreatePaddingFile, (::std::int64_t paddingSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreatePaddingFile, (paddingSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPaddingFiles)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteAllPaddingFiles);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsId, (::nn::sf::Out<::nn::fs::RightsId> outValue, ::nn::ncm::ProgramId programId, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRightsId, (outValue, programId, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterExternalKey, (const ::nn::fs::RightsId& rightsId, const ::nn::spl::AccessKey& accessKey))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterExternalKey, (rightsId, accessKey));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllExternalKey)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnregisterAllExternalKey);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsIdByPath, (::nn::sf::Out<::nn::fs::RightsId> outValue, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRightsIdByPath, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsIdAndKeyGenerationByPath, (::nn::sf::Out<::nn::fs::RightsId> outRightsId, ::nn::sf::Out<::std::uint8_t> outKeyGeneration, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRightsIdAndKeyGenerationByPath, (outRightsId, outKeyGeneration, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentPosixTimeWithTimeDifference, (::std::int64_t posixTime, ::std::int32_t timeDifference))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetCurrentPosixTimeWithTimeDifference, (posixTime, timeDifference));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSizeForSaveData, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFreeSpaceSizeForSaveData, (outValue, saveDataSpaceId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifySaveDataFileSystemBySaveDataSpaceId, (saveDataSpaceId, saveDataId, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CorruptSaveDataFileSystemBySaveDataSpaceId, (saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QuerySaveDataInternalStorageTotalSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QuerySaveDataInternalStorageTotalSize, (outValue, saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSaveDataCommitId, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSaveDataCommitId, (outValue, saveDataSpaceId, saveDataId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSdCardEncryptionSeed, (const ::nn::fs::EncryptionSeed& seed))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSdCardEncryptionSeed, (seed));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSdCardAccessibility, (bool isAccessible))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSdCardAccessibility, (isAccessible));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSdCardAccessible, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSdCardAccessible, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSignedSystemPartitionOnSdCardValid, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSignedSystemPartitionOnSdCardValid, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessFailureDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAccessFailureDetectionEventNotifier, (outValue, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccessFailureDetectionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccessFailureDetectionEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAccessFailureDetected, (::nn::sf::Out<bool> outValue, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAccessFailureDetected, (outValue, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveAccessFailure, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResolveAccessFailure, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AbandonAccessFailure, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AbandonAccessFailure, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearErrorInfo, (::nn::sf::Out<::nn::fs::FileSystemProxyErrorInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAndClearErrorInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBisRootForHost, (::std::uint32_t id, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBisRootForHost, (id, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSaveDataSize, (::std::int64_t size, ::std::int64_t journalSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSaveDataSize, (size, journalSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSaveDataRootPath, (const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSaveDataRootPath, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableAutoSaveDataCreation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableAutoSaveDataCreation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetGlobalAccessLogMode, (::std::uint32_t accessLogMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetGlobalAccessLogMode, (accessLogMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGlobalAccessLogMode, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGlobalAccessLogMode, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OutputAccessLogToSdCard, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OutputAccessLogToSdCard, (buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RegisterUpdatePartition)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RegisterUpdatePartition);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenRegisteredUpdatePartition, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenRegisteredUpdatePartition, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearMemoryReportInfo, (::nn::sf::Out<::nn::fs::MemoryReportInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAndClearMemoryReportInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDataStorageRedirectTarget, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDataStorageRedirectTarget, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OverrideSaveDataTransferTokenSignVerificationKey, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OverrideSaveDataTransferTokenSignVerificationKey, (buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenMultiCommitManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IMultiCommitManager>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenMultiCommitManager, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::fssrv::sf::IFileSystemProxy>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::fssrv::sf::IFileSystemProxy))

    // nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentProcess)

    // nn::Result OpenDataFileSystemByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDataFileSystemByCurrentProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDataFileSystemByCurrentProcess)

    // nn::Result OpenFileSystemWithPatch(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenFileSystemWithPatch)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenFileSystemWithPatch)

    // nn::Result OpenFileSystemWithId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::Bit64 programId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenFileSystemWithId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenFileSystemWithId)

    // nn::Result OpenDataFileSystemByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDataFileSystemByProgramId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDataFileSystemByProgramId)

    // nn::Result OpenBisFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, std::uint32_t id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenBisFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenBisFileSystem)

    // nn::Result OpenBisStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenBisStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenBisStorage)

    // nn::Result InvalidateBisCache() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InvalidateBisCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InvalidateBisCache)

    // nn::Result OpenHostFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenHostFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenHostFileSystem)

    // nn::Result OpenSdCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSdCardFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSdCardFileSystem)

    // nn::Result FormatSdCardFileSystem() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FormatSdCardFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FormatSdCardFileSystem)

    // nn::Result DeleteSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSaveDataFileSystem)

    // nn::Result CreateSaveDataFileSystem(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(creationInfo, (::nn::fs::SaveDataCreationInfo), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(metaInfo, (::nn::fs::SaveDataMetaInfo), 128)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (attribute, creationInfo, metaInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(144)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(creationInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(metaInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSaveDataFileSystem)

    // nn::Result CreateSaveDataFileSystemBySystemSaveDataId(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSaveDataFileSystemBySystemSaveDataId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(creationInfo, (::nn::fs::SaveDataCreationInfo), 64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (attribute, creationInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(creationInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSaveDataFileSystemBySystemSaveDataId)

    // nn::Result RegisterSaveDataFileSystemAtomicDeletion(const nn::sf::InBuffer& saveDataIdArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterSaveDataFileSystemAtomicDeletion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(saveDataIdArray, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (saveDataIdArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataIdArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterSaveDataFileSystemAtomicDeletion)

    // nn::Result DeleteSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSaveDataFileSystemBySaveDataSpaceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSaveDataFileSystemBySaveDataSpaceId)

    // nn::Result FormatSdCardDryRun() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FormatSdCardDryRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FormatSdCardDryRun)

    // nn::Result IsExFatSupported(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsExFatSupported)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsExFatSupported)

    // nn::Result DeleteSaveDataFileSystemBySaveDataAttribute(std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSaveDataFileSystemBySaveDataAttribute)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, attribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSaveDataFileSystemBySaveDataAttribute)

    // nn::Result OpenGameCardStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenGameCardStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(partition, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, partition))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(partition)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenGameCardStorage)

    // nn::Result OpenGameCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenGameCardFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(partition, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, partition))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(partition)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenGameCardFileSystem)

    // nn::Result ExtendSaveDataFileSystem(std::uint8_t spaceId, std::uint64_t saveDataId, std::int64_t saveDataAvailableSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtendSaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(spaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataAvailableSize, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataJournalSize, (::std::int64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (spaceId, saveDataId, saveDataAvailableSize, saveDataJournalSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(spaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataAvailableSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataJournalSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtendSaveDataFileSystem)

    // nn::Result DeleteCacheStorage(std::uint16_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteCacheStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteCacheStorage)

    // nn::Result GetCacheStorageSize(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outJournalSize, std::uint16_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCacheStorageSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outJournalSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outSize, outJournalSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outJournalSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCacheStorageSize)

    // nn::Result CreateSaveDataFileSystemWithHashSalt(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::HashSalt& salt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSaveDataFileSystemWithHashSalt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(creationInfo, (::nn::fs::SaveDataCreationInfo), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(metaInfo, (::nn::fs::SaveDataMetaInfo), 128)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(salt, (::nn::fs::HashSalt), 144)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (attribute, creationInfo, metaInfo, salt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(176)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(creationInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(metaInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(salt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSaveDataFileSystemWithHashSalt)

    // nn::Result OpenSaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, attribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataFileSystem)

    // nn::Result OpenSaveDataFileSystemBySystemSaveDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataFileSystemBySystemSaveDataId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, attribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataFileSystemBySystemSaveDataId)

    // nn::Result OpenReadOnlySaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenReadOnlySaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(53)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, attribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenReadOnlySaveDataFileSystem)

    // nn::Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(57)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)

    // nn::Result ReadSaveDataFileSystemExtraData(const nn::sf::OutBuffer& buffer, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadSaveDataFileSystemExtraData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(58)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadSaveDataFileSystemExtraData)

    // nn::Result WriteSaveDataFileSystemExtraData(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteSaveDataFileSystemExtraData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(59)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteSaveDataFileSystemExtraData)

    // nn::Result OpenSaveDataInfoReader(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataInfoReader)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataInfoReader)

    // nn::Result OpenSaveDataInfoReaderBySaveDataSpaceId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataInfoReaderBySaveDataSpaceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(61)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (saveDataSpaceId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataInfoReaderBySaveDataSpaceId)

    // nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataInfoReaderOnlyCacheStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(62)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataInfoReaderOnlyCacheStorage)

    // nn::Result OpenSaveDataInternalStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataInternalStorageFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataInternalStorageFileSystem)

    // nn::Result UpdateSaveDataMacForDebug(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateSaveDataMacForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(65)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateSaveDataMacForDebug)

    // nn::Result WriteSaveDataFileSystemExtraDataWithMask(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& extraDataValue, const nn::sf::InBuffer& extraDataMask) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteSaveDataFileSystemExtraDataWithMask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(66)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(extraDataValue, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(extraDataMask, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (extraDataValue, extraDataMask))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(extraDataValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(extraDataMask)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteSaveDataFileSystemExtraDataWithMask)

    // nn::Result FindSaveDataWithFilter(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindSaveDataWithFilter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(67)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::fs::SaveDataFilter), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindSaveDataWithFilter)

    // nn::Result OpenSaveDataInfoReaderWithFilter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataInfoReaderWithFilter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::fs::SaveDataFilter), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataInfoReaderWithFilter)

    // nn::Result OpenSaveDataMetaFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, std::uint32_t metaType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataMetaFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(metaType, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::fs::SaveDataAttribute), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (saveDataSpaceId, metaType, attribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(metaType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataMetaFile)

    // nn::Result OpenSaveDataTransferManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManager>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataTransferManager)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(81)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataTransferManager)

    // nn::Result OpenSaveDataTransferManagerVersion2(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataTransferManagerVersion2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(82)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataTransferManagerVersion2)

    // nn::Result OpenSaveDataTransferProhibiter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSaveDataTransferProhibiter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(83)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSaveDataTransferProhibiter)

    // nn::Result ListAccessibleSaveDataOwnerId(nn::sf::Out<std::int32_t> outValue, const nn::sf::OutBuffer& outBuffer, nn::ncm::ProgramId programId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAccessibleSaveDataOwnerId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(84)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(count, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (offset, count, programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAccessibleSaveDataOwnerId)

    // nn::Result OpenImageDirectoryFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenImageDirectoryFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenImageDirectoryFileSystem)

    // nn::Result OpenContentStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenContentStorageFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenContentStorageFileSystem)

    // nn::Result OpenCloudBackupWorkStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenCloudBackupWorkStorageFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenCloudBackupWorkStorageFileSystem)

    // nn::Result OpenDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDataStorageByCurrentProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDataStorageByCurrentProcess)

    // nn::Result OpenDataStorageByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDataStorageByProgramId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDataStorageByProgramId)

    // nn::Result OpenDataStorageByDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::DataId dataId, nn::Bit8 storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDataStorageByDataId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::Bit8), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataId, (::nn::ncm::DataId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storageId, dataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDataStorageByDataId)

    // nn::Result OpenPatchDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenPatchDataStorageByCurrentProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenPatchDataStorageByCurrentProcess)

    // nn::Result OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDeviceOperator)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDeviceOperator)

    // nn::Result OpenSdCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSdCardDetectionEventNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSdCardDetectionEventNotifier)

    // nn::Result OpenGameCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenGameCardDetectionEventNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenGameCardDetectionEventNotifier)

    // nn::Result OpenSystemDataUpdateEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSystemDataUpdateEventNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(510)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSystemDataUpdateEventNotifier)

    // nn::Result NotifySystemDataUpdateEvent() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifySystemDataUpdateEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(511)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifySystemDataUpdateEvent)

    // nn::Result SimulateDeviceDetectionEvent(std::uint32_t deviceType, std::uint32_t detectionEventType, bool isWithEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SimulateDeviceDetectionEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(520)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isWithEvent, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceType, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(detectionEventType, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (isWithEvent, deviceType, detectionEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(detectionEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isWithEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SimulateDeviceDetectionEvent)

    // nn::Result QuerySaveDataTotalSize(nn::sf::Out<std::int64_t> outValue, std::int64_t saveDataSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QuerySaveDataTotalSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataJournalSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSize, saveDataJournalSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataJournalSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QuerySaveDataTotalSize)

    // nn::Result VerifySaveDataFileSystem(std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifySaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(602)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifySaveDataFileSystem)

    // nn::Result CorruptSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CorruptSaveDataFileSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(603)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CorruptSaveDataFileSystem)

    // nn::Result CreatePaddingFile(std::int64_t paddingSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreatePaddingFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(604)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(paddingSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (paddingSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(paddingSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreatePaddingFile)

    // nn::Result DeleteAllPaddingFiles() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAllPaddingFiles)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(605)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAllPaddingFiles)

    // nn::Result GetRightsId(nn::sf::Out<nn::fs::RightsId> outValue, nn::ncm::ProgramId programId, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRightsId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(606)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storageId, programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::RightsId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRightsId)

    // nn::Result RegisterExternalKey(const nn::fs::RightsId& rightsId, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterExternalKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(607)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::fs::RightsId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (rightsId, accessKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterExternalKey)

    // nn::Result UnregisterAllExternalKey() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAllExternalKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(608)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAllExternalKey)

    // nn::Result GetRightsIdByPath(nn::sf::Out<nn::fs::RightsId> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRightsIdByPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(609)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::RightsId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRightsIdByPath)

    // nn::Result GetRightsIdAndKeyGenerationByPath(nn::sf::Out<nn::fs::RightsId> outRightsId, nn::sf::Out<std::uint8_t> outKeyGeneration, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRightsIdAndKeyGenerationByPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(610)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outKeyGeneration, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRightsId, (::nn::fs::RightsId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outKeyGeneration, outRightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightsId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outKeyGeneration), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRightsIdAndKeyGenerationByPath)

    // nn::Result SetCurrentPosixTimeWithTimeDifference(std::int64_t posixTime, std::int32_t timeDifference) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentPosixTimeWithTimeDifference)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(611)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeDifference, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(posixTime, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (timeDifference, posixTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(posixTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeDifference)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentPosixTimeWithTimeDifference)

    // nn::Result GetFreeSpaceSizeForSaveData(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFreeSpaceSizeForSaveData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(612)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (saveDataSpaceId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFreeSpaceSizeForSaveData)

    // nn::Result VerifySaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifySaveDataFileSystemBySaveDataSpaceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(613)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifySaveDataFileSystemBySaveDataSpaceId)

    // nn::Result CorruptSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CorruptSaveDataFileSystemBySaveDataSpaceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(614)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CorruptSaveDataFileSystemBySaveDataSpaceId)

    // nn::Result QuerySaveDataInternalStorageTotalSize(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QuerySaveDataInternalStorageTotalSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(615)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QuerySaveDataInternalStorageTotalSize)

    // nn::Result GetSaveDataCommitId(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSaveDataCommitId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(616)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataSpaceId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(saveDataId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (saveDataSpaceId, saveDataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataSpaceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(saveDataId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSaveDataCommitId)

    // nn::Result SetSdCardEncryptionSeed(const nn::fs::EncryptionSeed& seed) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSdCardEncryptionSeed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(620)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seed, (::nn::fs::EncryptionSeed), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (seed))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seed)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSdCardEncryptionSeed)

    // nn::Result SetSdCardAccessibility(bool isAccessible) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSdCardAccessibility)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(630)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isAccessible, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isAccessible))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isAccessible)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSdCardAccessibility)

    // nn::Result IsSdCardAccessible(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSdCardAccessible)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(631)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSdCardAccessible)

    // nn::Result IsSignedSystemPartitionOnSdCardValid(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSignedSystemPartitionOnSdCardValid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(640)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSignedSystemPartitionOnSdCardValid)

    // nn::Result OpenAccessFailureDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAccessFailureDetectionEventNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(700)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAccessFailureDetectionEventNotifier)

    // nn::Result GetAccessFailureDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccessFailureDetectionEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(701)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccessFailureDetectionEvent)

    // nn::Result IsAccessFailureDetected(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAccessFailureDetected)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(702)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAccessFailureDetected)

    // nn::Result ResolveAccessFailure(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResolveAccessFailure)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(710)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResolveAccessFailure)

    // nn::Result AbandonAccessFailure(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AbandonAccessFailure)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(720)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AbandonAccessFailure)

    // nn::Result GetAndClearErrorInfo(nn::sf::Out<nn::fs::FileSystemProxyErrorInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAndClearErrorInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(800)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::FileSystemProxyErrorInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAndClearErrorInfo)

    // nn::Result SetBisRootForHost(std::uint32_t id, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBisRootForHost)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBisRootForHost)

    // nn::Result SetSaveDataSize(std::int64_t size, std::int64_t journalSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSaveDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(journalSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (size, journalSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(journalSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSaveDataSize)

    // nn::Result SetSaveDataRootPath(const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSaveDataRootPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::FspPath&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSaveDataRootPath)

    // nn::Result DisableAutoSaveDataCreation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableAutoSaveDataCreation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableAutoSaveDataCreation)

    // nn::Result SetGlobalAccessLogMode(std::uint32_t accessLogMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetGlobalAccessLogMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessLogMode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accessLogMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessLogMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetGlobalAccessLogMode)

    // nn::Result GetGlobalAccessLogMode(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGlobalAccessLogMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGlobalAccessLogMode)

    // nn::Result OutputAccessLogToSdCard(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OutputAccessLogToSdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OutputAccessLogToSdCard)

    // nn::Result RegisterUpdatePartition() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterUpdatePartition)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterUpdatePartition)

    // nn::Result OpenRegisteredUpdatePartition(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenRegisteredUpdatePartition)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenRegisteredUpdatePartition)

    // nn::Result GetAndClearMemoryReportInfo(nn::sf::Out<nn::fs::MemoryReportInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAndClearMemoryReportInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::MemoryReportInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAndClearMemoryReportInfo)

    // nn::Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDataStorageRedirectTarget)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDataStorageRedirectTarget)

    // nn::Result OverrideSaveDataTransferTokenSignVerificationKey(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OverrideSaveDataTransferTokenSignVerificationKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OverrideSaveDataTransferTokenSignVerificationKey)

    // nn::Result OpenMultiCommitManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IMultiCommitManager>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenMultiCommitManager)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenMultiCommitManager)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::SaveDataAttribute), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::SaveDataCreationInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::SaveDataMetaInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::HashSalt), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::SaveDataFilter), 72, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::DataId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::RightsId), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::AccessKey), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::EncryptionSeed), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::FileSystemProxyErrorInfo), 128, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::MemoryReportInfo), 128, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::fssrv::sf::IFileSystemProxy, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::fssrv::sf::IFileSystemProxy))

    // nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentProcess, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentProcess)
    }

    // nn::Result OpenDataFileSystemByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataFileSystemByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDataFileSystemByCurrentProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDataFileSystemByCurrentProcess)
    }

    // nn::Result OpenFileSystemWithPatch(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenFileSystemWithPatch, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenFileSystemWithPatch)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenFileSystemWithPatch)
    }

    // nn::Result OpenFileSystemWithId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::Bit64 programId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenFileSystemWithId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::nn::Bit64 programId, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenFileSystemWithId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenFileSystemWithId)
    }

    // nn::Result OpenDataFileSystemByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataFileSystemByProgramId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::nn::ncm::ProgramId programId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDataFileSystemByProgramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDataFileSystemByProgramId)
    }

    // nn::Result OpenBisFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, std::uint32_t id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenBisFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path, ::std::uint32_t id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenBisFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenBisFileSystem)
    }

    // nn::Result OpenBisStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenBisStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenBisStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenBisStorage)
    }

    // nn::Result InvalidateBisCache() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InvalidateBisCache)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InvalidateBisCache)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InvalidateBisCache)
    }

    // nn::Result OpenHostFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenHostFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenHostFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenHostFileSystem)
    }

    // nn::Result OpenSdCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSdCardFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSdCardFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSdCardFileSystem)
    }

    // nn::Result FormatSdCardFileSystem() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCardFileSystem)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FormatSdCardFileSystem)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FormatSdCardFileSystem)
    }

    // nn::Result DeleteSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystem, (::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSaveDataFileSystem)
    }

    // nn::Result CreateSaveDataFileSystem(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystem, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(creationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(metaInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSaveDataFileSystem)
    }

    // nn::Result CreateSaveDataFileSystemBySystemSaveDataId(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemBySystemSaveDataId, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSaveDataFileSystemBySystemSaveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(creationInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSaveDataFileSystemBySystemSaveDataId)
    }

    // nn::Result RegisterSaveDataFileSystemAtomicDeletion(const nn::sf::InBuffer& saveDataIdArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSaveDataFileSystemAtomicDeletion, (const ::nn::sf::InBuffer& saveDataIdArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterSaveDataFileSystemAtomicDeletion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataIdArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterSaveDataFileSystemAtomicDeletion)
    }

    // nn::Result DeleteSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSaveDataFileSystemBySaveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSaveDataFileSystemBySaveDataSpaceId)
    }

    // nn::Result FormatSdCardDryRun() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCardDryRun)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FormatSdCardDryRun)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FormatSdCardDryRun)
    }

    // nn::Result IsExFatSupported(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsExFatSupported, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsExFatSupported)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsExFatSupported)
    }

    // nn::Result DeleteSaveDataFileSystemBySaveDataAttribute(std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSaveDataFileSystemBySaveDataAttribute, (::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSaveDataFileSystemBySaveDataAttribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSaveDataFileSystemBySaveDataAttribute)
    }

    // nn::Result OpenGameCardStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::std::uint32_t handle, ::std::uint32_t partition))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenGameCardStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(partition)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenGameCardStorage)
    }

    // nn::Result OpenGameCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t handle, ::std::uint32_t partition))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenGameCardFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(partition)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenGameCardFileSystem)
    }

    // nn::Result ExtendSaveDataFileSystem(std::uint8_t spaceId, std::uint64_t saveDataId, std::int64_t saveDataAvailableSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtendSaveDataFileSystem, (::std::uint8_t spaceId, ::std::uint64_t saveDataId, ::std::int64_t saveDataAvailableSize, ::std::int64_t saveDataJournalSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtendSaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(spaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataAvailableSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataJournalSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtendSaveDataFileSystem)
    }

    // nn::Result DeleteCacheStorage(std::uint16_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteCacheStorage, (::std::uint16_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteCacheStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteCacheStorage)
    }

    // nn::Result GetCacheStorageSize(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outJournalSize, std::uint16_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCacheStorageSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outJournalSize, ::std::uint16_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCacheStorageSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outJournalSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCacheStorageSize)
    }

    // nn::Result CreateSaveDataFileSystemWithHashSalt(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::HashSalt& salt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSaveDataFileSystemWithHashSalt, (const ::nn::fs::SaveDataAttribute& attribute, const ::nn::fs::SaveDataCreationInfo& creationInfo, const ::nn::fs::SaveDataMetaInfo& metaInfo, const ::nn::fs::HashSalt& salt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSaveDataFileSystemWithHashSalt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(creationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(metaInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(salt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSaveDataFileSystemWithHashSalt)
    }

    // nn::Result OpenSaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataFileSystem)
    }

    // nn::Result OpenSaveDataFileSystemBySystemSaveDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataFileSystemBySystemSaveDataId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataFileSystemBySystemSaveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataFileSystemBySystemSaveDataId)
    }

    // nn::Result OpenReadOnlySaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenReadOnlySaveDataFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenReadOnlySaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenReadOnlySaveDataFileSystem)
    }

    // nn::Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId, (const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)
    }

    // nn::Result ReadSaveDataFileSystemExtraData(const nn::sf::OutBuffer& buffer, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSaveDataFileSystemExtraData, (const ::nn::sf::OutBuffer& buffer, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadSaveDataFileSystemExtraData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadSaveDataFileSystemExtraData)
    }

    // nn::Result WriteSaveDataFileSystemExtraData(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraData, (::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteSaveDataFileSystemExtraData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteSaveDataFileSystemExtraData)
    }

    // nn::Result OpenSaveDataInfoReader(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReader, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataInfoReader)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataInfoReader)
    }

    // nn::Result OpenSaveDataInfoReaderBySaveDataSpaceId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderBySaveDataSpaceId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataInfoReaderBySaveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataInfoReaderBySaveDataSpaceId)
    }

    // nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderOnlyCacheStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataInfoReaderOnlyCacheStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataInfoReaderOnlyCacheStorage)
    }

    // nn::Result OpenSaveDataInternalStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInternalStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataInternalStorageFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataInternalStorageFileSystem)
    }

    // nn::Result UpdateSaveDataMacForDebug(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateSaveDataMacForDebug, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateSaveDataMacForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateSaveDataMacForDebug)
    }

    // nn::Result WriteSaveDataFileSystemExtraDataWithMask(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& extraDataValue, const nn::sf::InBuffer& extraDataMask) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSaveDataFileSystemExtraDataWithMask, (::std::uint64_t saveDataId, ::std::uint8_t saveDataSpaceId, const ::nn::sf::InBuffer& extraDataValue, const ::nn::sf::InBuffer& extraDataMask))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteSaveDataFileSystemExtraDataWithMask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(extraDataValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(extraDataMask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteSaveDataFileSystemExtraDataWithMask)
    }

    // nn::Result FindSaveDataWithFilter(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindSaveDataWithFilter, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::OutBuffer& buffer, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindSaveDataWithFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindSaveDataWithFilter)
    }

    // nn::Result OpenSaveDataInfoReaderWithFilter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataInfoReaderWithFilter, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataFilter& filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataInfoReaderWithFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataInfoReaderWithFilter)
    }

    // nn::Result OpenSaveDataMetaFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, std::uint32_t metaType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataMetaFile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, ::std::uint8_t saveDataSpaceId, const ::nn::fs::SaveDataAttribute& attribute, ::std::uint32_t metaType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataMetaFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(metaType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataMetaFile)
    }

    // nn::Result OpenSaveDataTransferManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManager>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManager>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataTransferManager)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataTransferManager)
    }

    // nn::Result OpenSaveDataTransferManagerVersion2(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferManagerVersion2, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataTransferManagerVersion2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataTransferManagerVersion2)
    }

    // nn::Result OpenSaveDataTransferProhibiter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSaveDataTransferProhibiter, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSaveDataTransferProhibiter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSaveDataTransferProhibiter)
    }

    // nn::Result ListAccessibleSaveDataOwnerId(nn::sf::Out<std::int32_t> outValue, const nn::sf::OutBuffer& outBuffer, nn::ncm::ProgramId programId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAccessibleSaveDataOwnerId, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ProgramId programId, ::std::int32_t offset, ::std::int32_t count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAccessibleSaveDataOwnerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAccessibleSaveDataOwnerId)
    }

    // nn::Result OpenImageDirectoryFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenImageDirectoryFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenImageDirectoryFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenImageDirectoryFileSystem)
    }

    // nn::Result OpenContentStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenContentStorageFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenContentStorageFileSystem)
    }

    // nn::Result OpenCloudBackupWorkStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenCloudBackupWorkStorageFileSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue, ::std::uint32_t storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenCloudBackupWorkStorageFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenCloudBackupWorkStorageFileSystem)
    }

    // nn::Result OpenDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDataStorageByCurrentProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDataStorageByCurrentProcess)
    }

    // nn::Result OpenDataStorageByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByProgramId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::ProgramId programId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDataStorageByProgramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDataStorageByProgramId)
    }

    // nn::Result OpenDataStorageByDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::DataId dataId, nn::Bit8 storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDataStorageByDataId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue, ::nn::ncm::DataId dataId, ::nn::Bit8 storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDataStorageByDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDataStorageByDataId)
    }

    // nn::Result OpenPatchDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenPatchDataStorageByCurrentProcess, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenPatchDataStorageByCurrentProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenPatchDataStorageByCurrentProcess)
    }

    // nn::Result OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDeviceOperator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDeviceOperator>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDeviceOperator)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDeviceOperator)
    }

    // nn::Result OpenSdCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSdCardDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSdCardDetectionEventNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSdCardDetectionEventNotifier)
    }

    // nn::Result OpenGameCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenGameCardDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenGameCardDetectionEventNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenGameCardDetectionEventNotifier)
    }

    // nn::Result OpenSystemDataUpdateEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSystemDataUpdateEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSystemDataUpdateEventNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSystemDataUpdateEventNotifier)
    }

    // nn::Result NotifySystemDataUpdateEvent() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifySystemDataUpdateEvent)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifySystemDataUpdateEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifySystemDataUpdateEvent)
    }

    // nn::Result SimulateDeviceDetectionEvent(std::uint32_t deviceType, std::uint32_t detectionEventType, bool isWithEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SimulateDeviceDetectionEvent, (::std::uint32_t deviceType, ::std::uint32_t detectionEventType, bool isWithEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SimulateDeviceDetectionEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(detectionEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isWithEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SimulateDeviceDetectionEvent)
    }

    // nn::Result QuerySaveDataTotalSize(nn::sf::Out<std::int64_t> outValue, std::int64_t saveDataSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QuerySaveDataTotalSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::int64_t saveDataSize, ::std::int64_t saveDataJournalSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QuerySaveDataTotalSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataJournalSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QuerySaveDataTotalSize)
    }

    // nn::Result VerifySaveDataFileSystem(std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystem, (::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifySaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifySaveDataFileSystem)
    }

    // nn::Result CorruptSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystem, (::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CorruptSaveDataFileSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CorruptSaveDataFileSystem)
    }

    // nn::Result CreatePaddingFile(std::int64_t paddingSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreatePaddingFile, (::std::int64_t paddingSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreatePaddingFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(paddingSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreatePaddingFile)
    }

    // nn::Result DeleteAllPaddingFiles() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPaddingFiles)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAllPaddingFiles)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAllPaddingFiles)
    }

    // nn::Result GetRightsId(nn::sf::Out<nn::fs::RightsId> outValue, nn::ncm::ProgramId programId, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsId, (::nn::sf::Out<::nn::fs::RightsId> outValue, ::nn::ncm::ProgramId programId, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRightsId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRightsId)
    }

    // nn::Result RegisterExternalKey(const nn::fs::RightsId& rightsId, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterExternalKey, (const ::nn::fs::RightsId& rightsId, const ::nn::spl::AccessKey& accessKey))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterExternalKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterExternalKey)
    }

    // nn::Result UnregisterAllExternalKey() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllExternalKey)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAllExternalKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAllExternalKey)
    }

    // nn::Result GetRightsIdByPath(nn::sf::Out<nn::fs::RightsId> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsIdByPath, (::nn::sf::Out<::nn::fs::RightsId> outValue, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRightsIdByPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRightsIdByPath)
    }

    // nn::Result GetRightsIdAndKeyGenerationByPath(nn::sf::Out<nn::fs::RightsId> outRightsId, nn::sf::Out<std::uint8_t> outKeyGeneration, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsIdAndKeyGenerationByPath, (::nn::sf::Out<::nn::fs::RightsId> outRightsId, ::nn::sf::Out<::std::uint8_t> outKeyGeneration, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRightsIdAndKeyGenerationByPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightsId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outKeyGeneration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRightsIdAndKeyGenerationByPath)
    }

    // nn::Result SetCurrentPosixTimeWithTimeDifference(std::int64_t posixTime, std::int32_t timeDifference) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentPosixTimeWithTimeDifference, (::std::int64_t posixTime, ::std::int32_t timeDifference))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentPosixTimeWithTimeDifference)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(posixTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeDifference)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentPosixTimeWithTimeDifference)
    }

    // nn::Result GetFreeSpaceSizeForSaveData(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSizeForSaveData, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFreeSpaceSizeForSaveData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFreeSpaceSizeForSaveData)
    }

    // nn::Result VerifySaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifySaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifySaveDataFileSystemBySaveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifySaveDataFileSystemBySaveDataSpaceId)
    }

    // nn::Result CorruptSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptSaveDataFileSystemBySaveDataSpaceId, (::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CorruptSaveDataFileSystemBySaveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CorruptSaveDataFileSystemBySaveDataSpaceId)
    }

    // nn::Result QuerySaveDataInternalStorageTotalSize(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QuerySaveDataInternalStorageTotalSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QuerySaveDataInternalStorageTotalSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QuerySaveDataInternalStorageTotalSize)
    }

    // nn::Result GetSaveDataCommitId(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSaveDataCommitId, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint8_t saveDataSpaceId, ::std::uint64_t saveDataId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSaveDataCommitId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataSpaceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(saveDataId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSaveDataCommitId)
    }

    // nn::Result SetSdCardEncryptionSeed(const nn::fs::EncryptionSeed& seed) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSdCardEncryptionSeed, (const ::nn::fs::EncryptionSeed& seed))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSdCardEncryptionSeed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seed)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSdCardEncryptionSeed)
    }

    // nn::Result SetSdCardAccessibility(bool isAccessible) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSdCardAccessibility, (bool isAccessible))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSdCardAccessibility)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isAccessible)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSdCardAccessibility)
    }

    // nn::Result IsSdCardAccessible(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSdCardAccessible, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSdCardAccessible)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSdCardAccessible)
    }

    // nn::Result IsSignedSystemPartitionOnSdCardValid(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSignedSystemPartitionOnSdCardValid, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSignedSystemPartitionOnSdCardValid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSignedSystemPartitionOnSdCardValid)
    }

    // nn::Result OpenAccessFailureDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessFailureDetectionEventNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>> outValue, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAccessFailureDetectionEventNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAccessFailureDetectionEventNotifier)
    }

    // nn::Result GetAccessFailureDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccessFailureDetectionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccessFailureDetectionEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccessFailureDetectionEvent)
    }

    // nn::Result IsAccessFailureDetected(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAccessFailureDetected, (::nn::sf::Out<bool> outValue, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAccessFailureDetected)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAccessFailureDetected)
    }

    // nn::Result ResolveAccessFailure(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveAccessFailure, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResolveAccessFailure)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResolveAccessFailure)
    }

    // nn::Result AbandonAccessFailure(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AbandonAccessFailure, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AbandonAccessFailure)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AbandonAccessFailure)
    }

    // nn::Result GetAndClearErrorInfo(nn::sf::Out<nn::fs::FileSystemProxyErrorInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearErrorInfo, (::nn::sf::Out<::nn::fs::FileSystemProxyErrorInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAndClearErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAndClearErrorInfo)
    }

    // nn::Result SetBisRootForHost(std::uint32_t id, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBisRootForHost, (::std::uint32_t id, const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBisRootForHost)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBisRootForHost)
    }

    // nn::Result SetSaveDataSize(std::int64_t size, std::int64_t journalSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSaveDataSize, (::std::int64_t size, ::std::int64_t journalSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSaveDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(journalSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSaveDataSize)
    }

    // nn::Result SetSaveDataRootPath(const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSaveDataRootPath, (const ::nn::fssrv::sf::FspPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSaveDataRootPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSaveDataRootPath)
    }

    // nn::Result DisableAutoSaveDataCreation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableAutoSaveDataCreation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableAutoSaveDataCreation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableAutoSaveDataCreation)
    }

    // nn::Result SetGlobalAccessLogMode(std::uint32_t accessLogMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetGlobalAccessLogMode, (::std::uint32_t accessLogMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetGlobalAccessLogMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessLogMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetGlobalAccessLogMode)
    }

    // nn::Result GetGlobalAccessLogMode(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGlobalAccessLogMode, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGlobalAccessLogMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGlobalAccessLogMode)
    }

    // nn::Result OutputAccessLogToSdCard(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OutputAccessLogToSdCard, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OutputAccessLogToSdCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OutputAccessLogToSdCard)
    }

    // nn::Result RegisterUpdatePartition() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RegisterUpdatePartition)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterUpdatePartition)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterUpdatePartition)
    }

    // nn::Result OpenRegisteredUpdatePartition(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenRegisteredUpdatePartition, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenRegisteredUpdatePartition)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenRegisteredUpdatePartition)
    }

    // nn::Result GetAndClearMemoryReportInfo(nn::sf::Out<nn::fs::MemoryReportInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearMemoryReportInfo, (::nn::sf::Out<::nn::fs::MemoryReportInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAndClearMemoryReportInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAndClearMemoryReportInfo)
    }

    // nn::Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDataStorageRedirectTarget, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDataStorageRedirectTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDataStorageRedirectTarget)
    }

    // nn::Result OverrideSaveDataTransferTokenSignVerificationKey(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OverrideSaveDataTransferTokenSignVerificationKey, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OverrideSaveDataTransferTokenSignVerificationKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OverrideSaveDataTransferTokenSignVerificationKey)
    }

    // nn::Result OpenMultiCommitManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IMultiCommitManager>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenMultiCommitManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IMultiCommitManager>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenMultiCommitManager)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenMultiCommitManager)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::fssrv::sf::IFileSystemProxy>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::fssrv::sf::IFileSystemProxy))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDataFileSystemByCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDataFileSystemByCurrentProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenFileSystemWithPatch)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenFileSystemWithPatch)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenFileSystemWithId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenFileSystemWithId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDataFileSystemByProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDataFileSystemByProgramId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenBisFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenBisFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenBisStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenBisStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InvalidateBisCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InvalidateBisCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenHostFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenHostFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSdCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSdCardFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FormatSdCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FormatSdCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(creationInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(metaInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSaveDataFileSystemBySystemSaveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSaveDataFileSystemBySystemSaveDataId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(creationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterSaveDataFileSystemAtomicDeletion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(saveDataIdArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterSaveDataFileSystemAtomicDeletion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(saveDataIdArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSaveDataFileSystemBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSaveDataFileSystemBySaveDataSpaceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FormatSdCardDryRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FormatSdCardDryRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsExFatSupported)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsExFatSupported)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSaveDataFileSystemBySaveDataAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSaveDataFileSystemBySaveDataAttribute)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenGameCardStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenGameCardStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(partition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenGameCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenGameCardFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(partition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtendSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtendSaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(spaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataAvailableSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataJournalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteCacheStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteCacheStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCacheStorageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCacheStorageSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outJournalSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSaveDataFileSystemWithHashSalt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSaveDataFileSystemWithHashSalt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(creationInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(metaInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(salt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataFileSystemBySystemSaveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataFileSystemBySystemSaveDataId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenReadOnlySaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenReadOnlySaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadSaveDataFileSystemExtraData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadSaveDataFileSystemExtraData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteSaveDataFileSystemExtraData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteSaveDataFileSystemExtraData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataInfoReader)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataInfoReader)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataInfoReaderBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataInfoReaderBySaveDataSpaceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataInfoReaderOnlyCacheStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataInfoReaderOnlyCacheStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataInternalStorageFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataInternalStorageFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateSaveDataMacForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateSaveDataMacForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteSaveDataFileSystemExtraDataWithMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(extraDataValue)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(extraDataMask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteSaveDataFileSystemExtraDataWithMask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(extraDataValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(extraDataMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindSaveDataWithFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindSaveDataWithFilter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataInfoReaderWithFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataInfoReader>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataInfoReaderWithFilter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataMetaFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataMetaFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(metaType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataTransferManager)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManager>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataTransferManager)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataTransferManagerVersion2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferManagerWithDivision>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataTransferManagerVersion2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSaveDataTransferProhibiter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::ISaveDataTransferProhibiter>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSaveDataTransferProhibiter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAccessibleSaveDataOwnerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAccessibleSaveDataOwnerId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenImageDirectoryFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenImageDirectoryFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenContentStorageFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenContentStorageFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenCloudBackupWorkStorageFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenCloudBackupWorkStorageFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDataStorageByCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDataStorageByCurrentProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDataStorageByProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDataStorageByProgramId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDataStorageByDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDataStorageByDataId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenPatchDataStorageByCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenPatchDataStorageByCurrentProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDeviceOperator)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IDeviceOperator>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDeviceOperator)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSdCardDetectionEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSdCardDetectionEventNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenGameCardDetectionEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenGameCardDetectionEventNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSystemDataUpdateEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSystemDataUpdateEventNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifySystemDataUpdateEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifySystemDataUpdateEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SimulateDeviceDetectionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SimulateDeviceDetectionEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(detectionEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isWithEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QuerySaveDataTotalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QuerySaveDataTotalSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataJournalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifySaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifySaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CorruptSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CorruptSaveDataFileSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreatePaddingFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreatePaddingFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(paddingSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAllPaddingFiles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAllPaddingFiles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRightsId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterExternalKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAllExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAllExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRightsIdByPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRightsIdByPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRightsIdAndKeyGenerationByPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRightsIdAndKeyGenerationByPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRightsId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outKeyGeneration),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentPosixTimeWithTimeDifference)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentPosixTimeWithTimeDifference)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(posixTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeDifference)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFreeSpaceSizeForSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFreeSpaceSizeForSaveData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifySaveDataFileSystemBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifySaveDataFileSystemBySaveDataSpaceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CorruptSaveDataFileSystemBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CorruptSaveDataFileSystemBySaveDataSpaceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QuerySaveDataInternalStorageTotalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QuerySaveDataInternalStorageTotalSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSaveDataCommitId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSaveDataCommitId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataSpaceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(saveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSdCardEncryptionSeed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSdCardEncryptionSeed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSdCardAccessibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSdCardAccessibility)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isAccessible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSdCardAccessible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSdCardAccessible)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSignedSystemPartitionOnSdCardValid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSignedSystemPartitionOnSdCardValid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAccessFailureDetectionEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IEventNotifier>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAccessFailureDetectionEventNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccessFailureDetectionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccessFailureDetectionEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAccessFailureDetected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAccessFailureDetected)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResolveAccessFailure)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResolveAccessFailure)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AbandonAccessFailure)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AbandonAccessFailure)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAndClearErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAndClearErrorInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBisRootForHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBisRootForHost)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSaveDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSaveDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(journalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSaveDataRootPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSaveDataRootPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableAutoSaveDataCreation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableAutoSaveDataCreation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetGlobalAccessLogMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetGlobalAccessLogMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessLogMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGlobalAccessLogMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGlobalAccessLogMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OutputAccessLogToSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OutputAccessLogToSdCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterUpdatePartition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterUpdatePartition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenRegisteredUpdatePartition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFileSystem>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenRegisteredUpdatePartition)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAndClearMemoryReportInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAndClearMemoryReportInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDataStorageRedirectTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDataStorageRedirectTarget)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OverrideSaveDataTransferTokenSignVerificationKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OverrideSaveDataTransferTokenSignVerificationKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenMultiCommitManager)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IMultiCommitManager>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenMultiCommitManager)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDataFileSystemByCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenFileSystemWithPatch)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenFileSystemWithId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDataFileSystemByProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenBisFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenBisStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InvalidateBisCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenHostFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSdCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FormatSdCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSaveDataFileSystemBySystemSaveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterSaveDataFileSystemAtomicDeletion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSaveDataFileSystemBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FormatSdCardDryRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsExFatSupported)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSaveDataFileSystemBySaveDataAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenGameCardStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenGameCardFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtendSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteCacheStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCacheStorageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSaveDataFileSystemWithHashSalt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataFileSystemBySystemSaveDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenReadOnlySaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadSaveDataFileSystemExtraDataBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadSaveDataFileSystemExtraData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteSaveDataFileSystemExtraData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataInfoReader)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataInfoReaderBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataInfoReaderOnlyCacheStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataInternalStorageFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateSaveDataMacForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteSaveDataFileSystemExtraDataWithMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindSaveDataWithFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataInfoReaderWithFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataMetaFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataTransferManager)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataTransferManagerVersion2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSaveDataTransferProhibiter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAccessibleSaveDataOwnerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenImageDirectoryFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenContentStorageFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenCloudBackupWorkStorageFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDataStorageByCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDataStorageByProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDataStorageByDataId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenPatchDataStorageByCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDeviceOperator)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSdCardDetectionEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenGameCardDetectionEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSystemDataUpdateEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifySystemDataUpdateEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SimulateDeviceDetectionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QuerySaveDataTotalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifySaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CorruptSaveDataFileSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreatePaddingFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAllPaddingFiles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAllExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRightsIdByPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRightsIdAndKeyGenerationByPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentPosixTimeWithTimeDifference)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFreeSpaceSizeForSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifySaveDataFileSystemBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CorruptSaveDataFileSystemBySaveDataSpaceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QuerySaveDataInternalStorageTotalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSaveDataCommitId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSdCardEncryptionSeed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSdCardAccessibility)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSdCardAccessible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSignedSystemPartitionOnSdCardValid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAccessFailureDetectionEventNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccessFailureDetectionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAccessFailureDetected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResolveAccessFailure)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AbandonAccessFailure)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAndClearErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBisRootForHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSaveDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSaveDataRootPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableAutoSaveDataCreation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetGlobalAccessLogMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGlobalAccessLogMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OutputAccessLogToSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterUpdatePartition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenRegisteredUpdatePartition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAndClearMemoryReportInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDataStorageRedirectTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OverrideSaveDataTransferTokenSignVerificationKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenMultiCommitManager)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::fssrv::sf::IFileSystemProxy))
