﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/fs/fs_ErrorInfoPrivate.h>
#include <nn/fs/fs_GameCard.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace fssrv { namespace sf { // NOLINT(whitespace/braces)

class IDeviceOperator;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDeviceOperator, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDeviceOperator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSdCardInserted, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardSpeedMode, (::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardCid, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardUserAreaSize, (::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardProtectedAreaSize, (::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearSdCardErrorInfo, (::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcCid, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcSpeedMode, (::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EraseMmc, (::std::uint32_t id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcPartitionSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint32_t id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcPatrolCount, (::nn::sf::Out<::std::uint32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearMmcErrorInfo, (::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcExtendedCsd, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(SuspendMmcPatrol)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResumeMmcPatrol)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsGameCardInserted, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EraseGameCard, (::std::uint32_t memorySizeId, ::std::uint64_t normalAreaSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardHandle, (::nn::sf::Out<::std::uint32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardUpdatePartitionInfo, (::nn::sf::Out<::std::uint32_t> outVersion, ::nn::sf::Out<::std::uint64_t> outId, ::std::uint32_t handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeGameCardDriver)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttribute, (::nn::sf::Out<::std::uint8_t> outValue, ::std::uint32_t handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceCertificate, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAsicInfo, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardIdSet, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteToGameCardDirectly, (::std::int64_t offset, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetVerifyWriteEnalbleFlag, (bool flag))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardImageHash, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceIdForProdCard, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EraseAndWriteParamDirectly, (const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadParamDirectly, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ForceEraseGameCard)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardErrorInfo, (::nn::sf::Out<::nn::fs::GameCardErrorInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardErrorReportInfo, (::nn::sf::Out<::nn::fs::GameCardErrorReportInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceId, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSpeedEmulationMode, (::std::int32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSpeedEmulationMode, (::nn::sf::Out<::std::int32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(SuspendSdmmcControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResumeSdmmcControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdmmcConnectionStatus, (::nn::sf::Out<::std::int32_t> outSdmmcSpeedMode, ::nn::sf::Out<::std::int32_t> outSdmmcBusWidth, ::std::int32_t sdmmcPort))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceSimulationEvent, (::std::uint32_t deviceType, ::std::uint32_t targetOperationFlag, ::std::uint32_t deviceEventType, ::std::uint32_t respondingFailureResultValue, bool isPersistent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearDeviceSimulationEvent, (::std::uint32_t deviceType))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDeviceOperator)

        ::nn::Result IsSdCardInserted(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSdCardInserted, (outValue));
        }

        ::nn::Result GetSdCardSpeedMode(::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdCardSpeedMode, (outValue));
        }

        ::nn::Result GetSdCardCid(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdCardCid, (outBuffer, size));
        }

        ::nn::Result GetSdCardUserAreaSize(::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdCardUserAreaSize, (outValue));
        }

        ::nn::Result GetSdCardProtectedAreaSize(::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdCardProtectedAreaSize, (outValue));
        }

        ::nn::Result GetAndClearSdCardErrorInfo(::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAndClearSdCardErrorInfo, (outStorageErrorInfo, outLogSize, outLogBuffer, logBufferSize));
        }

        ::nn::Result GetMmcCid(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMmcCid, (outBuffer, size));
        }

        ::nn::Result GetMmcSpeedMode(::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMmcSpeedMode, (outValue));
        }

        ::nn::Result EraseMmc(::std::uint32_t id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EraseMmc, (id));
        }

        ::nn::Result GetMmcPartitionSize(::nn::sf::Out<::std::int64_t> outValue, ::std::uint32_t id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMmcPartitionSize, (outValue, id));
        }

        ::nn::Result GetMmcPatrolCount(::nn::sf::Out<::std::uint32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMmcPatrolCount, (outValue));
        }

        ::nn::Result GetAndClearMmcErrorInfo(::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAndClearMmcErrorInfo, (outStorageErrorInfo, outLogSize, outLogBuffer, logBufferSize));
        }

        ::nn::Result GetMmcExtendedCsd(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMmcExtendedCsd, (outBuffer, size));
        }

        ::nn::Result SuspendMmcPatrol() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(SuspendMmcPatrol);
        }

        ::nn::Result ResumeMmcPatrol() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResumeMmcPatrol);
        }

        ::nn::Result IsGameCardInserted(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsGameCardInserted, (outValue));
        }

        ::nn::Result EraseGameCard(::std::uint32_t memorySizeId, ::std::uint64_t normalAreaSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EraseGameCard, (memorySizeId, normalAreaSize));
        }

        ::nn::Result GetGameCardHandle(::nn::sf::Out<::std::uint32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardHandle, (outValue));
        }

        ::nn::Result GetGameCardUpdatePartitionInfo(::nn::sf::Out<::std::uint32_t> outVersion, ::nn::sf::Out<::std::uint64_t> outId, ::std::uint32_t handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardUpdatePartitionInfo, (outVersion, outId, handle));
        }

        ::nn::Result FinalizeGameCardDriver() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FinalizeGameCardDriver);
        }

        ::nn::Result GetGameCardAttribute(::nn::sf::Out<::std::uint8_t> outValue, ::std::uint32_t handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardAttribute, (outValue, handle));
        }

        ::nn::Result GetGameCardDeviceCertificate(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardDeviceCertificate, (outBuffer, outBufferSize, handle));
        }

        ::nn::Result GetGameCardAsicInfo(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardAsicInfo, (outBuffer, outBufferSize, inBuffer, inBufferSize));
        }

        ::nn::Result GetGameCardIdSet(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardIdSet, (outBuffer, outBufferSize));
        }

        ::nn::Result WriteToGameCardDirectly(::std::int64_t offset, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteToGameCardDirectly, (offset, outBuffer, outBufferSize));
        }

        ::nn::Result SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetVerifyWriteEnalbleFlag, (flag));
        }

        ::nn::Result GetGameCardImageHash(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardImageHash, (outBuffer, outBufferSize, handle));
        }

        ::nn::Result GetGameCardDeviceIdForProdCard(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardDeviceIdForProdCard, (outBuffer, outBufferSize, inBuffer, inBufferSize));
        }

        ::nn::Result EraseAndWriteParamDirectly(const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EraseAndWriteParamDirectly, (inBuffer, inBufferSize));
        }

        ::nn::Result ReadParamDirectly(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadParamDirectly, (outBuffer, outBufferSize));
        }

        ::nn::Result ForceEraseGameCard() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ForceEraseGameCard);
        }

        ::nn::Result GetGameCardErrorInfo(::nn::sf::Out<::nn::fs::GameCardErrorInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardErrorInfo, (outValue));
        }

        ::nn::Result GetGameCardErrorReportInfo(::nn::sf::Out<::nn::fs::GameCardErrorReportInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardErrorReportInfo, (outValue));
        }

        ::nn::Result GetGameCardDeviceId(const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardDeviceId, (outBuffer, outBufferSize));
        }

        ::nn::Result SetSpeedEmulationMode(::std::int32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSpeedEmulationMode, (mode));
        }

        ::nn::Result GetSpeedEmulationMode(::nn::sf::Out<::std::int32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSpeedEmulationMode, (outValue));
        }

        ::nn::Result SuspendSdmmcControl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(SuspendSdmmcControl);
        }

        ::nn::Result ResumeSdmmcControl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResumeSdmmcControl);
        }

        ::nn::Result GetSdmmcConnectionStatus(::nn::sf::Out<::std::int32_t> outSdmmcSpeedMode, ::nn::sf::Out<::std::int32_t> outSdmmcBusWidth, ::std::int32_t sdmmcPort) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdmmcConnectionStatus, (outSdmmcSpeedMode, outSdmmcBusWidth, sdmmcPort));
        }

        ::nn::Result SetDeviceSimulationEvent(::std::uint32_t deviceType, ::std::uint32_t targetOperationFlag, ::std::uint32_t deviceEventType, ::std::uint32_t respondingFailureResultValue, bool isPersistent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDeviceSimulationEvent, (deviceType, targetOperationFlag, deviceEventType, respondingFailureResultValue, isPersistent));
        }

        ::nn::Result ClearDeviceSimulationEvent(::std::uint32_t deviceType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearDeviceSimulationEvent, (deviceType));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDeviceOperator
    {
    public:
        nn::Result IsSdCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetSdCardSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result GetSdCardCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
        nn::Result GetSdCardUserAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result GetSdCardProtectedAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result GetAndClearSdCardErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT;
        nn::Result GetMmcCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
        nn::Result GetMmcSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result EraseMmc(std::uint32_t id) NN_NOEXCEPT;
        nn::Result GetMmcPartitionSize(nn::sf::Out<std::int64_t> outValue, std::uint32_t id) NN_NOEXCEPT;
        nn::Result GetMmcPatrolCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
        nn::Result GetAndClearMmcErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT;
        nn::Result GetMmcExtendedCsd(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
        nn::Result SuspendMmcPatrol() NN_NOEXCEPT;
        nn::Result ResumeMmcPatrol() NN_NOEXCEPT;
        nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result EraseGameCard(std::uint32_t memorySizeId, std::uint64_t normalAreaSize) NN_NOEXCEPT;
        nn::Result GetGameCardHandle(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardUpdatePartitionInfo(nn::sf::Out<std::uint32_t> outVersion, nn::sf::Out<std::uint64_t> outId, std::uint32_t handle) NN_NOEXCEPT;
        nn::Result FinalizeGameCardDriver() NN_NOEXCEPT;
        nn::Result GetGameCardAttribute(nn::sf::Out<std::uint8_t> outValue, std::uint32_t handle) NN_NOEXCEPT;
        nn::Result GetGameCardDeviceCertificate(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT;
        nn::Result GetGameCardAsicInfo(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
        nn::Result GetGameCardIdSet(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        nn::Result WriteToGameCardDirectly(std::int64_t offset, const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        nn::Result SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT;
        nn::Result GetGameCardImageHash(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT;
        nn::Result GetGameCardDeviceIdForProdCard(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
        nn::Result EraseAndWriteParamDirectly(const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
        nn::Result ReadParamDirectly(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        nn::Result ForceEraseGameCard() NN_NOEXCEPT;
        nn::Result GetGameCardErrorInfo(nn::sf::Out<nn::fs::GameCardErrorInfo> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardErrorReportInfo(nn::sf::Out<nn::fs::GameCardErrorReportInfo> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardDeviceId(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
        nn::Result SetSpeedEmulationMode(std::int32_t mode) NN_NOEXCEPT;
        nn::Result GetSpeedEmulationMode(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
        nn::Result SuspendSdmmcControl() NN_NOEXCEPT;
        nn::Result ResumeSdmmcControl() NN_NOEXCEPT;
        nn::Result GetSdmmcConnectionStatus(nn::sf::Out<std::int32_t> outSdmmcSpeedMode, nn::sf::Out<std::int32_t> outSdmmcBusWidth, std::int32_t sdmmcPort) NN_NOEXCEPT;
        nn::Result SetDeviceSimulationEvent(std::uint32_t deviceType, std::uint32_t targetOperationFlag, std::uint32_t deviceEventType, std::uint32_t respondingFailureResultValue, bool isPersistent) NN_NOEXCEPT;
        nn::Result ClearDeviceSimulationEvent(std::uint32_t deviceType) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result IsSdCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetSdCardSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result GetSdCardCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
    nn::Result GetSdCardUserAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result GetSdCardProtectedAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result GetAndClearSdCardErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT;
    nn::Result GetMmcCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
    nn::Result GetMmcSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result EraseMmc(std::uint32_t id) NN_NOEXCEPT;
    nn::Result GetMmcPartitionSize(nn::sf::Out<std::int64_t> outValue, std::uint32_t id) NN_NOEXCEPT;
    nn::Result GetMmcPatrolCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
    nn::Result GetAndClearMmcErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT;
    nn::Result GetMmcExtendedCsd(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT;
    nn::Result SuspendMmcPatrol() NN_NOEXCEPT;
    nn::Result ResumeMmcPatrol() NN_NOEXCEPT;
    nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result EraseGameCard(std::uint32_t memorySizeId, std::uint64_t normalAreaSize) NN_NOEXCEPT;
    nn::Result GetGameCardHandle(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardUpdatePartitionInfo(nn::sf::Out<std::uint32_t> outVersion, nn::sf::Out<std::uint64_t> outId, std::uint32_t handle) NN_NOEXCEPT;
    nn::Result FinalizeGameCardDriver() NN_NOEXCEPT;
    nn::Result GetGameCardAttribute(nn::sf::Out<std::uint8_t> outValue, std::uint32_t handle) NN_NOEXCEPT;
    nn::Result GetGameCardDeviceCertificate(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT;
    nn::Result GetGameCardAsicInfo(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
    nn::Result GetGameCardIdSet(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
    nn::Result WriteToGameCardDirectly(std::int64_t offset, const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
    nn::Result SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT;
    nn::Result GetGameCardImageHash(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT;
    nn::Result GetGameCardDeviceIdForProdCard(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
    nn::Result EraseAndWriteParamDirectly(const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT;
    nn::Result ReadParamDirectly(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
    nn::Result ForceEraseGameCard() NN_NOEXCEPT;
    nn::Result GetGameCardErrorInfo(nn::sf::Out<nn::fs::GameCardErrorInfo> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardErrorReportInfo(nn::sf::Out<nn::fs::GameCardErrorReportInfo> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardDeviceId(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT;
    nn::Result SetSpeedEmulationMode(std::int32_t mode) NN_NOEXCEPT;
    nn::Result GetSpeedEmulationMode(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
    nn::Result SuspendSdmmcControl() NN_NOEXCEPT;
    nn::Result ResumeSdmmcControl() NN_NOEXCEPT;
    nn::Result GetSdmmcConnectionStatus(nn::sf::Out<std::int32_t> outSdmmcSpeedMode, nn::sf::Out<std::int32_t> outSdmmcBusWidth, std::int32_t sdmmcPort) NN_NOEXCEPT;
    nn::Result SetDeviceSimulationEvent(std::uint32_t deviceType, std::uint32_t targetOperationFlag, std::uint32_t deviceEventType, std::uint32_t respondingFailureResultValue, bool isPersistent) NN_NOEXCEPT;
    nn::Result ClearDeviceSimulationEvent(std::uint32_t deviceType) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::fssrv::sf::IDeviceOperator))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSdCardInserted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSdCardInserted, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardSpeedMode, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdCardSpeedMode, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardCid, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdCardCid, (outBuffer, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardUserAreaSize, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdCardUserAreaSize, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardProtectedAreaSize, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdCardProtectedAreaSize, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearSdCardErrorInfo, (::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAndClearSdCardErrorInfo, (outStorageErrorInfo, outLogSize, outLogBuffer, logBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcCid, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMmcCid, (outBuffer, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcSpeedMode, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMmcSpeedMode, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EraseMmc, (::std::uint32_t id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EraseMmc, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcPartitionSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint32_t id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMmcPartitionSize, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcPatrolCount, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMmcPatrolCount, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearMmcErrorInfo, (::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAndClearMmcErrorInfo, (outStorageErrorInfo, outLogSize, outLogBuffer, logBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcExtendedCsd, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMmcExtendedCsd, (outBuffer, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SuspendMmcPatrol)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(SuspendMmcPatrol);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResumeMmcPatrol)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResumeMmcPatrol);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsGameCardInserted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsGameCardInserted, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EraseGameCard, (::std::uint32_t memorySizeId, ::std::uint64_t normalAreaSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EraseGameCard, (memorySizeId, normalAreaSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardHandle, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardHandle, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardUpdatePartitionInfo, (::nn::sf::Out<::std::uint32_t> outVersion, ::nn::sf::Out<::std::uint64_t> outId, ::std::uint32_t handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardUpdatePartitionInfo, (outVersion, outId, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeGameCardDriver)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FinalizeGameCardDriver);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttribute, (::nn::sf::Out<::std::uint8_t> outValue, ::std::uint32_t handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardAttribute, (outValue, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceCertificate, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardDeviceCertificate, (outBuffer, outBufferSize, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAsicInfo, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardAsicInfo, (outBuffer, outBufferSize, inBuffer, inBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardIdSet, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardIdSet, (outBuffer, outBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteToGameCardDirectly, (::std::int64_t offset, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteToGameCardDirectly, (offset, outBuffer, outBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVerifyWriteEnalbleFlag, (bool flag))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetVerifyWriteEnalbleFlag, (flag));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardImageHash, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardImageHash, (outBuffer, outBufferSize, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceIdForProdCard, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardDeviceIdForProdCard, (outBuffer, outBufferSize, inBuffer, inBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EraseAndWriteParamDirectly, (const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EraseAndWriteParamDirectly, (inBuffer, inBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadParamDirectly, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadParamDirectly, (outBuffer, outBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ForceEraseGameCard)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ForceEraseGameCard);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardErrorInfo, (::nn::sf::Out<::nn::fs::GameCardErrorInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardErrorInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardErrorReportInfo, (::nn::sf::Out<::nn::fs::GameCardErrorReportInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardErrorReportInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceId, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardDeviceId, (outBuffer, outBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSpeedEmulationMode, (::std::int32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSpeedEmulationMode, (mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSpeedEmulationMode, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSpeedEmulationMode, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SuspendSdmmcControl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(SuspendSdmmcControl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResumeSdmmcControl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResumeSdmmcControl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdmmcConnectionStatus, (::nn::sf::Out<::std::int32_t> outSdmmcSpeedMode, ::nn::sf::Out<::std::int32_t> outSdmmcBusWidth, ::std::int32_t sdmmcPort))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdmmcConnectionStatus, (outSdmmcSpeedMode, outSdmmcBusWidth, sdmmcPort));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceSimulationEvent, (::std::uint32_t deviceType, ::std::uint32_t targetOperationFlag, ::std::uint32_t deviceEventType, ::std::uint32_t respondingFailureResultValue, bool isPersistent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDeviceSimulationEvent, (deviceType, targetOperationFlag, deviceEventType, respondingFailureResultValue, isPersistent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearDeviceSimulationEvent, (::std::uint32_t deviceType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearDeviceSimulationEvent, (deviceType));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::fssrv::sf::IDeviceOperator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::fssrv::sf::IDeviceOperator))

    // nn::Result IsSdCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSdCardInserted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSdCardInserted)

    // nn::Result GetSdCardSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdCardSpeedMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdCardSpeedMode)

    // nn::Result GetSdCardCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdCardCid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdCardCid)

    // nn::Result GetSdCardUserAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdCardUserAreaSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdCardUserAreaSize)

    // nn::Result GetSdCardProtectedAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdCardProtectedAreaSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdCardProtectedAreaSize)

    // nn::Result GetAndClearSdCardErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAndClearSdCardErrorInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outLogBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outLogBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(logBufferSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (logBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStorageErrorInfo, (::nn::fs::StorageErrorInfo), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLogSize, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outStorageErrorInfo, outLogSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStorageErrorInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLogSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLogBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(logBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAndClearSdCardErrorInfo)

    // nn::Result GetMmcCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMmcCid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMmcCid)

    // nn::Result GetMmcSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMmcSpeedMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMmcSpeedMode)

    // nn::Result EraseMmc(std::uint32_t id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EraseMmc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EraseMmc)

    // nn::Result GetMmcPartitionSize(nn::sf::Out<std::int64_t> outValue, std::uint32_t id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMmcPartitionSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMmcPartitionSize)

    // nn::Result GetMmcPatrolCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMmcPatrolCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(112)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMmcPatrolCount)

    // nn::Result GetAndClearMmcErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAndClearMmcErrorInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(113)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outLogBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outLogBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(logBufferSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (logBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStorageErrorInfo, (::nn::fs::StorageErrorInfo), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLogSize, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outStorageErrorInfo, outLogSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStorageErrorInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLogSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLogBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(logBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAndClearMmcErrorInfo)

    // nn::Result GetMmcExtendedCsd(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMmcExtendedCsd)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(114)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMmcExtendedCsd)

    // nn::Result SuspendMmcPatrol() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SuspendMmcPatrol)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(115)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SuspendMmcPatrol)

    // nn::Result ResumeMmcPatrol() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeMmcPatrol)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(116)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeMmcPatrol)

    // nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsGameCardInserted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsGameCardInserted)

    // nn::Result EraseGameCard(std::uint32_t memorySizeId, std::uint64_t normalAreaSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EraseGameCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(memorySizeId, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(normalAreaSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (memorySizeId, normalAreaSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(memorySizeId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(normalAreaSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EraseGameCard)

    // nn::Result GetGameCardHandle(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardHandle)

    // nn::Result GetGameCardUpdatePartitionInfo(nn::sf::Out<std::uint32_t> outVersion, nn::sf::Out<std::uint64_t> outId, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardUpdatePartitionInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outVersion, outId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardUpdatePartitionInfo)

    // nn::Result FinalizeGameCardDriver() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinalizeGameCardDriver)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinalizeGameCardDriver)

    // nn::Result GetGameCardAttribute(nn::sf::Out<std::uint8_t> outValue, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardAttribute)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardAttribute)

    // nn::Result GetGameCardDeviceCertificate(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardDeviceCertificate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, outBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardDeviceCertificate)

    // nn::Result GetGameCardAsicInfo(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardAsicInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inBufferSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (outBufferSize, inBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardAsicInfo)

    // nn::Result GetGameCardIdSet(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardIdSet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardIdSet)

    // nn::Result WriteToGameCardDirectly(std::int64_t offset, const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteToGameCardDirectly)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, outBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteToGameCardDirectly)

    // nn::Result SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetVerifyWriteEnalbleFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flag, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flag))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flag)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetVerifyWriteEnalbleFlag)

    // nn::Result GetGameCardImageHash(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardImageHash)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(211)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, outBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardImageHash)

    // nn::Result GetGameCardDeviceIdForProdCard(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardDeviceIdForProdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(212)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inBufferSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (outBufferSize, inBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardDeviceIdForProdCard)

    // nn::Result EraseAndWriteParamDirectly(const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EraseAndWriteParamDirectly)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(213)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inBufferSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EraseAndWriteParamDirectly)

    // nn::Result ReadParamDirectly(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadParamDirectly)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(214)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadParamDirectly)

    // nn::Result ForceEraseGameCard() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ForceEraseGameCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(215)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ForceEraseGameCard)

    // nn::Result GetGameCardErrorInfo(nn::sf::Out<nn::fs::GameCardErrorInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardErrorInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(216)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::GameCardErrorInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardErrorInfo)

    // nn::Result GetGameCardErrorReportInfo(nn::sf::Out<nn::fs::GameCardErrorReportInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardErrorReportInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(217)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::GameCardErrorReportInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardErrorReportInfo)

    // nn::Result GetGameCardDeviceId(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardDeviceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(218)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardDeviceId)

    // nn::Result SetSpeedEmulationMode(std::int32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSpeedEmulationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSpeedEmulationMode)

    // nn::Result GetSpeedEmulationMode(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSpeedEmulationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSpeedEmulationMode)

    // nn::Result SuspendSdmmcControl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SuspendSdmmcControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SuspendSdmmcControl)

    // nn::Result ResumeSdmmcControl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeSdmmcControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeSdmmcControl)

    // nn::Result GetSdmmcConnectionStatus(nn::sf::Out<std::int32_t> outSdmmcSpeedMode, nn::sf::Out<std::int32_t> outSdmmcBusWidth, std::int32_t sdmmcPort) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdmmcConnectionStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sdmmcPort, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sdmmcPort))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSdmmcSpeedMode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSdmmcBusWidth, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outSdmmcSpeedMode, outSdmmcBusWidth))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSdmmcSpeedMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSdmmcBusWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sdmmcPort)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdmmcConnectionStatus)

    // nn::Result SetDeviceSimulationEvent(std::uint32_t deviceType, std::uint32_t targetOperationFlag, std::uint32_t deviceEventType, std::uint32_t respondingFailureResultValue, bool isPersistent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDeviceSimulationEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPersistent, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceType, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetOperationFlag, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceEventType, (::std::uint32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(respondingFailureResultValue, (::std::uint32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (isPersistent, deviceType, targetOperationFlag, deviceEventType, respondingFailureResultValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetOperationFlag), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(respondingFailureResultValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPersistent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDeviceSimulationEvent)

    // nn::Result ClearDeviceSimulationEvent(std::uint32_t deviceType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearDeviceSimulationEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearDeviceSimulationEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::StorageErrorInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::GameCardErrorInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::GameCardErrorReportInfo), 64, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::fssrv::sf::IDeviceOperator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::fssrv::sf::IDeviceOperator))

    // nn::Result IsSdCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSdCardInserted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSdCardInserted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSdCardInserted)
    }

    // nn::Result GetSdCardSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardSpeedMode, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdCardSpeedMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdCardSpeedMode)
    }

    // nn::Result GetSdCardCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardCid, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdCardCid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdCardCid)
    }

    // nn::Result GetSdCardUserAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardUserAreaSize, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdCardUserAreaSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdCardUserAreaSize)
    }

    // nn::Result GetSdCardProtectedAreaSize(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardProtectedAreaSize, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdCardProtectedAreaSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdCardProtectedAreaSize)
    }

    // nn::Result GetAndClearSdCardErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearSdCardErrorInfo, (::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAndClearSdCardErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStorageErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLogSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLogBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(logBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAndClearSdCardErrorInfo)
    }

    // nn::Result GetMmcCid(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcCid, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMmcCid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMmcCid)
    }

    // nn::Result GetMmcSpeedMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcSpeedMode, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMmcSpeedMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMmcSpeedMode)
    }

    // nn::Result EraseMmc(std::uint32_t id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EraseMmc, (::std::uint32_t id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EraseMmc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EraseMmc)
    }

    // nn::Result GetMmcPartitionSize(nn::sf::Out<std::int64_t> outValue, std::uint32_t id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcPartitionSize, (::nn::sf::Out<::std::int64_t> outValue, ::std::uint32_t id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMmcPartitionSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMmcPartitionSize)
    }

    // nn::Result GetMmcPatrolCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcPatrolCount, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMmcPatrolCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMmcPatrolCount)
    }

    // nn::Result GetAndClearMmcErrorInfo(nn::sf::Out<nn::fs::StorageErrorInfo> outStorageErrorInfo, nn::sf::Out<std::int64_t> outLogSize, const nn::sf::OutBuffer& outLogBuffer, std::int64_t logBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAndClearMmcErrorInfo, (::nn::sf::Out<::nn::fs::StorageErrorInfo> outStorageErrorInfo, ::nn::sf::Out<::std::int64_t> outLogSize, const ::nn::sf::OutBuffer& outLogBuffer, ::std::int64_t logBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAndClearMmcErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStorageErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLogSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLogBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(logBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAndClearMmcErrorInfo)
    }

    // nn::Result GetMmcExtendedCsd(const nn::sf::OutBuffer& outBuffer, std::int64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMmcExtendedCsd, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMmcExtendedCsd)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMmcExtendedCsd)
    }

    // nn::Result SuspendMmcPatrol() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SuspendMmcPatrol)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SuspendMmcPatrol)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SuspendMmcPatrol)
    }

    // nn::Result ResumeMmcPatrol() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResumeMmcPatrol)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeMmcPatrol)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeMmcPatrol)
    }

    // nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsGameCardInserted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsGameCardInserted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsGameCardInserted)
    }

    // nn::Result EraseGameCard(std::uint32_t memorySizeId, std::uint64_t normalAreaSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EraseGameCard, (::std::uint32_t memorySizeId, ::std::uint64_t normalAreaSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EraseGameCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(memorySizeId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(normalAreaSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EraseGameCard)
    }

    // nn::Result GetGameCardHandle(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardHandle, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardHandle)
    }

    // nn::Result GetGameCardUpdatePartitionInfo(nn::sf::Out<std::uint32_t> outVersion, nn::sf::Out<std::uint64_t> outId, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardUpdatePartitionInfo, (::nn::sf::Out<::std::uint32_t> outVersion, ::nn::sf::Out<::std::uint64_t> outId, ::std::uint32_t handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardUpdatePartitionInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardUpdatePartitionInfo)
    }

    // nn::Result FinalizeGameCardDriver() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeGameCardDriver)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinalizeGameCardDriver)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinalizeGameCardDriver)
    }

    // nn::Result GetGameCardAttribute(nn::sf::Out<std::uint8_t> outValue, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttribute, (::nn::sf::Out<::std::uint8_t> outValue, ::std::uint32_t handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardAttribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardAttribute)
    }

    // nn::Result GetGameCardDeviceCertificate(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceCertificate, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardDeviceCertificate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardDeviceCertificate)
    }

    // nn::Result GetGameCardAsicInfo(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAsicInfo, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardAsicInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardAsicInfo)
    }

    // nn::Result GetGameCardIdSet(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardIdSet, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardIdSet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardIdSet)
    }

    // nn::Result WriteToGameCardDirectly(std::int64_t offset, const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteToGameCardDirectly, (::std::int64_t offset, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteToGameCardDirectly)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteToGameCardDirectly)
    }

    // nn::Result SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVerifyWriteEnalbleFlag, (bool flag))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetVerifyWriteEnalbleFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flag)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetVerifyWriteEnalbleFlag)
    }

    // nn::Result GetGameCardImageHash(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, std::uint32_t handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardImageHash, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, ::std::uint32_t handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardImageHash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardImageHash)
    }

    // nn::Result GetGameCardDeviceIdForProdCard(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize, const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceIdForProdCard, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize, const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardDeviceIdForProdCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardDeviceIdForProdCard)
    }

    // nn::Result EraseAndWriteParamDirectly(const nn::sf::InBuffer& inBuffer, std::int64_t inBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EraseAndWriteParamDirectly, (const ::nn::sf::InBuffer& inBuffer, ::std::int64_t inBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EraseAndWriteParamDirectly)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EraseAndWriteParamDirectly)
    }

    // nn::Result ReadParamDirectly(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadParamDirectly, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadParamDirectly)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadParamDirectly)
    }

    // nn::Result ForceEraseGameCard() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ForceEraseGameCard)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ForceEraseGameCard)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ForceEraseGameCard)
    }

    // nn::Result GetGameCardErrorInfo(nn::sf::Out<nn::fs::GameCardErrorInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardErrorInfo, (::nn::sf::Out<::nn::fs::GameCardErrorInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardErrorInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardErrorInfo)
    }

    // nn::Result GetGameCardErrorReportInfo(nn::sf::Out<nn::fs::GameCardErrorReportInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardErrorReportInfo, (::nn::sf::Out<::nn::fs::GameCardErrorReportInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardErrorReportInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardErrorReportInfo)
    }

    // nn::Result GetGameCardDeviceId(const nn::sf::OutBuffer& outBuffer, std::int64_t outBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardDeviceId, (const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t outBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardDeviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardDeviceId)
    }

    // nn::Result SetSpeedEmulationMode(std::int32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSpeedEmulationMode, (::std::int32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSpeedEmulationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSpeedEmulationMode)
    }

    // nn::Result GetSpeedEmulationMode(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSpeedEmulationMode, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSpeedEmulationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSpeedEmulationMode)
    }

    // nn::Result SuspendSdmmcControl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SuspendSdmmcControl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SuspendSdmmcControl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SuspendSdmmcControl)
    }

    // nn::Result ResumeSdmmcControl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResumeSdmmcControl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeSdmmcControl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeSdmmcControl)
    }

    // nn::Result GetSdmmcConnectionStatus(nn::sf::Out<std::int32_t> outSdmmcSpeedMode, nn::sf::Out<std::int32_t> outSdmmcBusWidth, std::int32_t sdmmcPort) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdmmcConnectionStatus, (::nn::sf::Out<::std::int32_t> outSdmmcSpeedMode, ::nn::sf::Out<::std::int32_t> outSdmmcBusWidth, ::std::int32_t sdmmcPort))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdmmcConnectionStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSdmmcSpeedMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSdmmcBusWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sdmmcPort)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdmmcConnectionStatus)
    }

    // nn::Result SetDeviceSimulationEvent(std::uint32_t deviceType, std::uint32_t targetOperationFlag, std::uint32_t deviceEventType, std::uint32_t respondingFailureResultValue, bool isPersistent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceSimulationEvent, (::std::uint32_t deviceType, ::std::uint32_t targetOperationFlag, ::std::uint32_t deviceEventType, ::std::uint32_t respondingFailureResultValue, bool isPersistent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDeviceSimulationEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetOperationFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(respondingFailureResultValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPersistent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDeviceSimulationEvent)
    }

    // nn::Result ClearDeviceSimulationEvent(std::uint32_t deviceType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearDeviceSimulationEvent, (::std::uint32_t deviceType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearDeviceSimulationEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearDeviceSimulationEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::fssrv::sf::IDeviceOperator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::fssrv::sf::IDeviceOperator))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSdCardInserted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSdCardInserted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdCardSpeedMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdCardSpeedMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdCardCid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdCardCid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdCardUserAreaSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdCardUserAreaSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdCardProtectedAreaSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdCardProtectedAreaSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAndClearSdCardErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outLogBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAndClearSdCardErrorInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStorageErrorInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLogSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outLogBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(logBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMmcCid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMmcCid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMmcSpeedMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMmcSpeedMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EraseMmc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EraseMmc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMmcPartitionSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMmcPartitionSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMmcPatrolCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMmcPatrolCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAndClearMmcErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outLogBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAndClearMmcErrorInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStorageErrorInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLogSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outLogBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(logBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMmcExtendedCsd)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMmcExtendedCsd)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SuspendMmcPatrol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SuspendMmcPatrol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeMmcPatrol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeMmcPatrol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsGameCardInserted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsGameCardInserted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EraseGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EraseGameCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(memorySizeId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(normalAreaSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardUpdatePartitionInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardUpdatePartitionInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinalizeGameCardDriver)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinalizeGameCardDriver)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardAttribute)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardDeviceCertificate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardDeviceCertificate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardAsicInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardAsicInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardIdSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardIdSet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteToGameCardDirectly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteToGameCardDirectly)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetVerifyWriteEnalbleFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetVerifyWriteEnalbleFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardImageHash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardImageHash)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardDeviceIdForProdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardDeviceIdForProdCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EraseAndWriteParamDirectly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EraseAndWriteParamDirectly)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadParamDirectly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadParamDirectly)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ForceEraseGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ForceEraseGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardErrorInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardErrorReportInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardErrorReportInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardDeviceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSpeedEmulationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSpeedEmulationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSpeedEmulationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSpeedEmulationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SuspendSdmmcControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SuspendSdmmcControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeSdmmcControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeSdmmcControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdmmcConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdmmcConnectionStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSdmmcSpeedMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSdmmcBusWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sdmmcPort)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDeviceSimulationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDeviceSimulationEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetOperationFlag),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(respondingFailureResultValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPersistent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearDeviceSimulationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearDeviceSimulationEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSdCardInserted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdCardSpeedMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdCardCid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdCardUserAreaSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdCardProtectedAreaSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAndClearSdCardErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMmcCid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMmcSpeedMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EraseMmc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMmcPartitionSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMmcPatrolCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAndClearMmcErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMmcExtendedCsd)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SuspendMmcPatrol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeMmcPatrol)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsGameCardInserted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EraseGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardUpdatePartitionInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinalizeGameCardDriver)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardDeviceCertificate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardAsicInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardIdSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteToGameCardDirectly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetVerifyWriteEnalbleFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardImageHash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardDeviceIdForProdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EraseAndWriteParamDirectly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadParamDirectly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ForceEraseGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardErrorInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardErrorReportInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSpeedEmulationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSpeedEmulationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SuspendSdmmcControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeSdmmcControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdmmcConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDeviceSimulationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearDeviceSimulationEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::fssrv::sf::IDeviceOperator))
