﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_IStorage.h>
#include <nn/fs/fs_SpeedEmulation.h>
#include <nn/fs/detail/fs_Newable.h>

namespace nn { namespace fssrv {


class SpeedEmulationStorage : public nn::fs::IStorage, public nn::fs::detail::Newable
{
public:
    explicit SpeedEmulationStorage(nn::fs::IStorage* pBaseStorage) NN_NOEXCEPT;

    virtual ~SpeedEmulationStorage() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    virtual Result Read(int64_t offset, void* buffer, size_t size) NN_NOEXCEPT NN_OVERRIDE;

    virtual Result Write(int64_t offset, const void* buffer, size_t size) NN_NOEXCEPT NN_OVERRIDE;

    virtual Result Flush() NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pBaseStorage->Flush();
    }

    virtual Result GetSize(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pBaseStorage->GetSize(outValue);
    }

    virtual Result OperateRange(
        void* outBuffer,
        size_t outBufferSize,
        fs::OperationId operationId,
        int64_t offset,
        int64_t size,
        const void* inBuffer,
        size_t inBufferSize
    ) NN_NOEXCEPT NN_OVERRIDE;

private:
    bool IsSequentialAccess(bool isRead, int64_t offset) const NN_NOEXCEPT;

private:
    nn::fs::IStorage* m_pBaseStorage;

    bool m_IsPreviousRead;
    int64_t m_PreviousEnd;
};

}}
