﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/fs/fs_SdCardPrivate.h>

namespace nn { namespace fssrv { namespace fscreator {



    class EncryptedFileSystemCreator : public IEncryptedFileSystemCreator
    {
        NN_DISALLOW_COPY(EncryptedFileSystemCreator);
        NN_DISALLOW_MOVE(EncryptedFileSystemCreator);

    public:

        struct Key
        {
            char value[16];
        };
        NN_STATIC_ASSERT(std::is_pod<Key>::value);

        typedef void(*GetEncryptionKeyFunction)(Key* pOutValueKey, int keyCount, KeyId id, const nn::fs::EncryptionSeed& seed);
        typedef void(*GenerateRandomFunction)(void* pData, size_t size);

        struct Configuration
        {
            GetEncryptionKeyFunction pGetKeyFunction;
            GenerateRandomFunction   pGenerateRandomFunction;
        };
        NN_STATIC_ASSERT(std::is_pod<Configuration>::value);

    public:
        explicit EncryptedFileSystemCreator(const Configuration& configuration) NN_NOEXCEPT;
        virtual Result Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> pFileSystem, KeyId id, const nn::fs::EncryptionSeed& seed) NN_NOEXCEPT;

    private:
        GetEncryptionKeyFunction m_pGenerateKey;
        GenerateRandomFunction   m_pGenerateRandom;
    };

}}}
