﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  システムデータ更新通知関連 API の宣言
*/


#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

//! @name システムデータ更新通知関連 API
//! @{

namespace nn { namespace fs {

//--------------------------------------------------------------------------
/**
*   @brief      システムデータが更新されたことを通知します。
*
*   @return     処理の結果が返ります。
*/
Result NotifySystemDataUpdateEvent() NN_NOEXCEPT;

}}
