﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  システムデータ関連 API の宣言
*/


#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>

namespace nn { namespace fs {

//! @name システムデータ関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      MountSystemData のファイルシステムキャッシュに必要なサイズを取得します。
*
*   @param[out] pOutValue   ファイルシステムキャッシュに必要なサイズ
*   @param[in]  dataId      システムデータの識別子
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                   成功しました。
*   @retval     ResultDataCorrupted             ファイルシステムが壊れています。
*   @retval     ResultAllocationMemoryFailed    fs ライブラリが使用するメモリアロケータからのメモリ確保に失敗しました。
*   @retval     ResultTargetNotFound            dataId のシステムデータがインストールされていません。
*
*   @pre
*       - pOutValue が有効なメモリを指している。
*/
Result QueryMountSystemDataCacheSize(size_t* pOutValue, nn::ncm::SystemDataId dataId) NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
*   @brief      指定した ID のシステムデータを扱う読み込み専用のファイルシステムをマウントします。この関数は廃止予定です。
*
*   @deprecated この関数は廃止予定です。
*
*   @param[in]  name       マウント名
*   @param[in]  dataId     システムデータの識別子
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*   @retval     ResultMountNameAlreadyExists    name で表されるファイルシステムが既に存在しています。
*   @retval     ResultDataCorrupted             ファイルシステムが壊れています。
*   @retval     ResultAllocationMemoryFailed    fs ライブラリが使用するメモリアロケータからのメモリ確保に失敗しました。
*   @retval     ResultTargetNotFound        dataId のシステムデータがインストールされていません。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*
*   @details    この関数は廃止される予定です。@n
*               キャッシュを利用する MountSystemData(const char* name, nn::ncm::SystemDataId dataId, void* pFileSystemCacheBuffer, size_t fileSystemCacheBufferSize) を使用してください。
*/
Result MountSystemData(const char* name, nn::ncm::SystemDataId dataId) NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
*   @brief      指定した ID のシステムデータを扱う読み込み専用のファイルシステムをマウントします。
*
*   @param[in]  name                      マウント名
*   @param[in]  dataId                    システムデータの識別子
*   @param[in]  pFileSystemCacheBuffer    ファイルシステムキャッシュのバッファ
*   @param[in]  fileSystemCacheBufferSize バッファのサイズ（必要なバッファサイズは QueryMountSystemDataCacheSize(size_t* pOutValue, nn::ncm::SystemDataId dataId) で取得できます。）
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                   成功しました。
*   @retval     ResultMountNameAlreadyExists    name で表されるファイルシステムが既に存在しています。
*   @retval     ResultDataCorrupted             ファイルシステムが壊れています。
*   @retval     ResultAllocationMemoryFailed    fs ライブラリが使用するメモリアロケータからのメモリ確保に失敗しました。
*   @retval     ResultTargetNotFound            dataId のシステムデータがインストールされていません。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*       - pFileSystemCacheBuffer != nullptr
*       - fileSystemCacheBufferSize が QueryMountSystemDataCacheSize(size_t* pOutValue, nn::ncm::SystemDataId dataId) で取得できるサイズ以上
*/
Result MountSystemData(const char* name, nn::ncm::SystemDataId dataId, void* pFileSystemCacheBuffer, size_t fileSystemCacheBufferSize) NN_NOEXCEPT;

}}
