﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace fs {

/**
*   @brief      プライベートな Result 値が返った際の自動 abort を有効化・無効化します。
*
*   @param[in]  isEnabled    true なら有効化、false なら無効化
*
*   @return     なし
*
*   @details    有効な状態では、fs からプライベートな Result 値が返った際に自動で abort します。@n
*               無効な状態では、全ての Result 値を各 API の返り値としてそのまま返します。@n
*               初期状態は有効状態です。@n
*               状態はプロセス全体に影響します。
*/
void SetEnabledAutoAbort(bool isEnabled);

/**
*   @brief      アプリケーションによる Result ハンドリングに設定します。
*
*   @param[in]  isApplication    true なら有効化、false なら無効化
*
*   @return     なし
*
*   @details    isApplication に true を指定した場合はアプリケーションがハンドリングすべきではない Result 値は返さず内部で abort します。
*/
void SetResultHandledByApplication(bool isApplication);

}}
