﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace fs {

/**
*   @brief      メモリレポート情報を表す構造体です。
*/
struct MemoryReportInfo
{
    uint64_t pooledBufferPeakFreeSize;      //!< PooledBuffer の空き領域サイズのピーク
    uint64_t pooledBufferRetriedCount;      //!< PooledBuffer のリトライ回数
    uint64_t pooledBufferReduceAllocationCount; //!< PooledBuffer の出し渋り回数
    uint64_t bufferManagerPeakFreeSize;     //!< BufferManager の空き領域サイズのピーク
    uint64_t bufferManagerRetriedCount;     //!< BufferManager のリトライ回数
    uint64_t expHeapPeakFreeSize;           //!< ExpHeap の空き領域サイズのピーク
    uint64_t bufferPoolPeakFreeSize;        //!< BufferPool の空き領域サイズのピーク
    uint64_t patrolReadAllocateBufferSuccessCount;  //!< PatrolRead におけるバッファ確保成功回数
    uint64_t patrolReadAllocateBufferFailureCount;  //!< PatrolRead におけるバッファ確保失敗回数
    uint64_t bufferManagerPeakTotalAllocatableSize; //!< BufferManager の割り当て可能な領域の合計サイズのピーク
    uint8_t reserved[128 - (sizeof(uint64_t) * 10)];
};
NN_STATIC_ASSERT(std::is_pod<MemoryReportInfo>::value);
NN_STATIC_ASSERT(sizeof(MemoryReportInfo) == 128);

/**
*   @brief      メモリレポート情報を取得し、クリアします。
*
*   @param[out] pOutMemoryReportInfo    取得したメモリレポート情報の格納先
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*
*   @pre
*       - pOutMemoryReportInfo が有効なメモリを指している。
*/
Result GetAndClearMemoryReportInfo(MemoryReportInfo* pOutMemoryReportInfo) NN_NOEXCEPT;

}}
