﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  BCAT セーブデータ関連 API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/fs/fs_SaveDataTransaction.h>

namespace nn { namespace fs {

//! @name BCAT 用のセーブデータ関連 API
//! @{


//--------------------------------------------------------------------------
/**
*   @brief      ID に紐づいた BCAT 用のセーブデータをマウントします。
*
*   @param[in]  name       マウント名
*   @param[in]  id         アプリケーションID
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*/
Result MountBcatSaveData(const char* name, ::nn::ncm::ApplicationId id) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs

