﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Device Tree の内部関数の宣言
 *
 * @detail  Detice Tree の API が内部的に使用する関数です。
 *          このファイルで定義されている関数を直接呼び出すことは禁止されています。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/dt/dt_Types.h>

namespace nn { namespace dt { namespace detail {

constexpr bool IsSupportedPropertySize(int propertySize)
{
    return propertySize == 1 || propertySize == 2 || propertySize == 4 || propertySize == 8;
}

nn::Result GetPropertyCount(int *pOutCount, const Node* pNode, const char* name, size_t elementSize) NN_NOEXCEPT;
nn::Result GetProperty(char* pOutValue, const Node* pNode, const char* name, size_t elementSize) NN_NOEXCEPT;
nn::Result GetProperty(char* pOutValue, const Node* pNode, const char* name, int index, size_t elementSize) NN_NOEXCEPT;
nn::Result GetPropertyArray(char* pOutArray, int count, const Node* pNode, const char* name, size_t elementSize) NN_NOEXCEPT;
nn::Result GetPropertyList(char* pOutList, int* pOutCount, int maxCount, const Node* pNode, const char* name, size_t elementSize) NN_NOEXCEPT;

}}}
