﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Device Tree 内部用 API の宣言
 * @detail  DDK では公開しない、内部用 API の宣言です。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace dt { namespace detail {

class IDeviceTree;

/**
 * @brief   テスト用に DT ライブラリを初期化します。
 *
 * @pre     他の DT ライブラリの API を実行していない。
 * @details テスト用に DT ライブラリの初期化処理を行います。
 *          ライブラリの他の関数を実行すると、通常用のライブラリ初期化が行われてしまうので、その前にこの関数を実行する必要があります。
 */
void InitializeWith(nn::sf::SharedPointer<IDeviceTree>&& manager) NN_NOEXCEPT;

}}}
