﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      drivers モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_DRIVERS_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_DRIVERS_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_DRIVERS_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_DRIVERS_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_DRIVERS_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_DRIVERS_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(drivers, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_DRIVERS_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Trace, 0, format, args)
#define NN_DETAIL_DRIVERS_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Trace, 1, format, args)
#define NN_DETAIL_DRIVERS_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Trace, 2, format, args)
#define NN_DETAIL_DRIVERS_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Trace, 3, format, args)

#define NN_DETAIL_DRIVERS_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Info, 0, format, args)
#define NN_DETAIL_DRIVERS_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Info, 1, format, args)
#define NN_DETAIL_DRIVERS_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Info, 2, format, args)
#define NN_DETAIL_DRIVERS_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Info, 3, format, args)

#define NN_DETAIL_DRIVERS_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Warn, 0, format, args)
#define NN_DETAIL_DRIVERS_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Warn, 1, format, args)
#define NN_DETAIL_DRIVERS_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Warn, 2, format, args)
#define NN_DETAIL_DRIVERS_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Warn, 3, format, args)

#define NN_DETAIL_DRIVERS_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Error, 0, format, args)
#define NN_DETAIL_DRIVERS_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Error, 1, format, args)
#define NN_DETAIL_DRIVERS_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Error, 2, format, args)
#define NN_DETAIL_DRIVERS_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Error, 3, format, args)

#define NN_DETAIL_DRIVERS_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Fatal, 0, format, args)
#define NN_DETAIL_DRIVERS_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Fatal, 1, format, args)
#define NN_DETAIL_DRIVERS_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Fatal, 2, format, args)
#define NN_DETAIL_DRIVERS_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(drivers, Fatal, 3, format, args)

#define NN_DETAIL_DRIVERS_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Trace, 0, text, length)
#define NN_DETAIL_DRIVERS_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Trace, 1, text, length)
#define NN_DETAIL_DRIVERS_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Trace, 2, text, length)
#define NN_DETAIL_DRIVERS_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Trace, 3, text, length)

#define NN_DETAIL_DRIVERS_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Info, 0, text, length)
#define NN_DETAIL_DRIVERS_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Info, 1, text, length)
#define NN_DETAIL_DRIVERS_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Info, 2, text, length)
#define NN_DETAIL_DRIVERS_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Info, 3, text, length)

#define NN_DETAIL_DRIVERS_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Warn, 0, text, length)
#define NN_DETAIL_DRIVERS_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Warn, 1, text, length)
#define NN_DETAIL_DRIVERS_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Warn, 2, text, length)
#define NN_DETAIL_DRIVERS_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Warn, 3, text, length)

#define NN_DETAIL_DRIVERS_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Error, 0, text, length)
#define NN_DETAIL_DRIVERS_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Error, 1, text, length)
#define NN_DETAIL_DRIVERS_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Error, 2, text, length)
#define NN_DETAIL_DRIVERS_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Error, 3, text, length)

#define NN_DETAIL_DRIVERS_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Fatal, 0, text, length)
#define NN_DETAIL_DRIVERS_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Fatal, 1, text, length)
#define NN_DETAIL_DRIVERS_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Fatal, 2, text, length)
#define NN_DETAIL_DRIVERS_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(drivers, Fatal, 3, text, length)
