﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief DHCP Protocol Definition
 *
 * @details
 */

namespace nn { namespace bsdsocket { namespace dhcpc {

enum DhcpProtPorts
{
    DhcpProtPorts_Server    = 67,
    DhcpProtPorts_Client    = 68,
};

enum DhcpProtOpCode
{
    DhcpProtOpCode_BootRequest   = 1,
    DhcpProtOpCode_BootReply     = 2,
};

enum DhcpProtMsgType
{
    DhcpProtMsgType_Discover       = 1,
    DhcpProtMsgType_Offer          = 2,
    DhcpProtMsgType_Request        = 3,
    DhcpProtMsgType_Decline        = 4,
    DhcpProtMsgType_Ack            = 5,
    DhcpProtMsgType_Nak            = 6,
    DhcpProtMsgType_Release        = 7,
    DhcpProtMsgType_Inform         = 8,
    DhcpProtMsgType_ForceRenew     = 9,
};



/* DHCP Protocol Options */
enum DhcpProtOption : uint8_t
{
    DhcpProtOption_Pad                    = 0, /* RFC 2132 */
    DhcpProtOption_SubnetMask             = 1,
    DhcpProtOption_Router                 = 3,
    DhcpProtOption_DnsServer              = 6,
    DhcpProtOption_Hostname               = 12,
    DhcpProtOption_DnsDomain              = 15,
    DhcpProtOption_Mtu                    = 26,
    DhcpProtOption_Broadcast              = 28,
    DhcpProtOption_StaticRoute            = 33,
    DhcpProtOption_NisDomain              = 40,
    DhcpProtOption_NisServer              = 41,
    DhcpProtOption_NtpServer              = 42,
    DhcpProtOption_Vendor                 = 43,
    DhcpProtOption_IpAddress              = 50,
    DhcpProtOption_LeaseTime              = 51,
    DhcpProtOption_OptionsOverloaded      = 52,
    DhcpProtOption_MessageType            = 53,
    DhcpProtOption_ServerId               = 54,
    DhcpProtOption_ParameterRequestList   = 55,
    DhcpProtOption_Message                = 56,
    DhcpProtOption_MaxMessageSize         = 57,
    DhcpProtOption_RenewalTime            = 58,
    DhcpProtOption_RebindTime             = 59,
    DhcpProtOption_VendorClassId          = 60,
    DhcpProtOption_ClientId               = 61,
    DhcpProtOption_UserClass              = 77,  /* RFC 3004 */
    DhcpProtOption_RapidCommit            = 80,  /* RFC 4039 */
    DhcpProtOption_Fqdn                   = 81,
    DhcpProtOption_Authentication         = 90,  /* RFC 3118 */
    DhcpProtOption_AutoConfigure          = 116, /* RFC 2563 */
    DhcpProtOption_DnsSearch              = 119, /* RFC 3397 */
    DhcpProtOption_Csr                    = 121, /* RFC 3442 */
    DhcpProtOption_Vivco                  = 124, /* RFC 3925 */
    DhcpProtOption_Vivso                  = 125, /* RFC 3925 */
    DhcpProtOption_ForceRenewNonce        = 145, /* RFC 6704 */
    DhcpProtOption_Sixrd                  = 212, /* RFC 5969 */
    DhcpProtOption_Mscsr                  = 249, /* MS code for RFC 3442 */
    DhcpProtOption_End                    = 255
};

enum DhcpProtAuth
{
    DhcpProtAuth_AlgHmacMd5     = 1,
};


//  Fully Qualified Domain Name
enum DhcpProtFqdn
{
    DhcpProtFqdn_Disable    = 0x00,
    DhcpProtFqdn_None       = 0x18,
    DhcpProtFqdn_Ptr        = 0x20,
    DhcpProtFqdn_Both       = 0x31,
};

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn






