﻿using Nintendo.Nact;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SigloNact.BuiltIns.Target
{
    [NactActionFunctionContainer]
    public static class CreateThreadDefinitionHeaderContainer
    {
        [NactActionFunction]
        public static NactActionResult CreateThreadDefinitionHeader(
            INactActionContext context,
            FilePath output,
            IEnumerable<string> threadDefinitionStrings,
            FilePath templateFile)
        {
            var helper = context.Helper;

            var templateStrings = helper.ReadAllLines(templateFile, new UTF8Encoding(true));
            // TORIAEZU: 移行前にあわせて空行を挟んでおく
            var contents = templateStrings.Concat(new[] { string.Empty }).Concat(threadDefinitionStrings).ToArray();
            helper.WriteAllLines(output, contents, new UTF8Encoding(true));

            return helper.FinishAsSuccess();
        }
    }
}
