﻿using Nintendo.Nact;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities.VisualStudio;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace SigloNact.BuiltIns.Common
{
    [NactActionFunctionContainer]
    public static class ExecuteCsScriptContainer
    {
        [NactActionFunction]
        public static NactActionResult ExecuteCsScript(
            INactActionContext context,
            FilePath scriptFile,
            IEnumerable<string> scriptArguments,
            IEnumerable<FilePath> referenceAssemblies)
        {
            var helper = context.Helper;

            var vsInstance = NactPluginGlobal.VisualStudioCollection.GetMSBuild(VisualStudioCollection.VisualStudio15ChannelId);
            if (vsInstance == null)
            {
                helper.SetErrorSummary("MSBuild 15 not found.");
                return helper.FinishAsFailure();
            }

            var csiPath = $@"{vsInstance.InstallationPath}\MSBuild\15.0\Bin\Roslyn\csi.exe";

            var csiCommandArguments = GetCsiCommandArguments(scriptFile, scriptArguments, referenceAssemblies);

            var executionResult = helper.ExecuteProgram(FilePath.CreateLocalFileSystemPath(csiPath), csiCommandArguments);

            return helper.FinishWithExitCode(executionResult.ExitCode);
        }

        private static string GetCsiCommandArguments(FilePath scriptFile, IEnumerable<string> scriptArguments, IEnumerable<FilePath> referenceAssemblies)
        {
            var arguments = new List<string>();

            arguments.AddRange(referenceAssemblies.Select(x => $"/r:{x.PathString}"));

            arguments.Add(scriptFile.PathString);

            arguments.AddRange(scriptArguments);

            return string.Join(" ", arguments);
        }
    }
}
