﻿using Nintendo.Nact;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace SigloNact.BuiltIns.Common
{
    [NactFunctionContainer]
    public static class ConvertNactMapToUtf8XmlTextRepresentationContainer
    {
        [NactFunction]
        public static string ConvertNactMapToUtf8XmlTextRepresentation(IReadOnlyDictionary<string, object> map, bool removesEmptyMap)
        {
            var xml = ConvertNactMapToXml(map, removesEmptyMap);

            byte[] bytes;
            using (var ms = new MemoryStream())
            {
                using (var sw = new StreamWriter(ms, Encoding.UTF8))
                {
                    xml.Save(sw);
                }
                bytes = ms.ToArray();
            }
            using (var ms = new MemoryStream(bytes))
            {
                using (var sr = new StreamReader(ms, true))
                {
                    return sr.ReadToEnd();
                }
            }
        }

        private static XElement ConvertNactMapToXml(IReadOnlyDictionary<string, object> map, bool removesEmptyMap)
        {
            var kv = default(KeyValuePair<string, object>);

            try
            {
                kv = map.Single();
            }
            catch (InvalidOperationException)
            {
                if (map.Count < 1)
                {
                    throw new ErrorException("Missing root element for an xml.");
                }
                else
                {
                    throw new ErrorException("There is more than one root element for an xml.");
                }
            }

            return new XElement(kv.Key, ConvertNactValueToXmlRecursively(kv.Value, removesEmptyMap));
        }

        private static object ConvertNactValueToXmlRecursively(object value, bool removesEmptyMap)
        {
            if (value == null)
            {
                return null;
            }

            if (value is IReadOnlyDictionary<string, object>)
            {
                var dic = (IReadOnlyDictionary<string, object>)value;

                var ret = dic.SelectMany(kv =>
                {
                    var vals = default(IEnumerable<object>);

                    if (kv.Value is IEnumerable<object>)
                    {
                        vals = (IEnumerable<object>)kv.Value;
                    }
                    else
                    {
                        vals = new object[] { kv.Value };
                    }
                    return vals.Select(v => ConvertNactValueToXmlRecursively(v, removesEmptyMap))
                               .Where(v => v != null)
                               .Select(v => new XElement(kv.Key, v));
                });

                if (removesEmptyMap && !ret.Any())
                {
                    return null;
                }
                else
                {
                    return ret;
                }
            }
            else if (value is string)
            {
                return value;
            }
            else if (value is double)
            {
                return value;
            }
            else if (value is bool)
            {
                return value;
            }
            else
            {
                throw new ErrorException(string.Format("Unexpected type value detected. Type = {0}", value.GetType().Name));
            }
        }
    }
}
