﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;

namespace SigloNact.BuiltIns.Common
{
    [NactActionFunctionContainer]
    public static class ConcatenateFilesContainer
    {
        [NactActionFunction]
        public static NactActionResult ConcatenateFiles(
            INactActionContext context,
            FilePath outputPath,
            IReadOnlyCollection<FilePath> inputPathList,
            string maxSizeText)
        {
            Concatenate(outputPath.PathString, inputPathList.Select(x => x.PathString).ToArray(), maxSizeText);

            return NactActionResult.CreateSuccess(inputPathList, new[] { outputPath });
        }

        private static void Concatenate(string outputPath, string[] inputPathList, string maxSizeText)
        {
            long maxSize;
            if (maxSizeText.StartsWith("0x") || maxSizeText.StartsWith("0X"))
            {
                maxSize = Convert.ToInt64(maxSizeText.Substring(2), 16);
            }
            else
            {
                maxSize = Convert.ToInt64(maxSizeText, 10);
            }

            long totalSize = 0;
            foreach (var inputPath in inputPathList)
            {
                if (!File.Exists(inputPath))
                {
                    throw new Exception(string.Format("{0} is not found.", inputPath));
                }

                var fileInfo = new FileInfo(inputPath);
                totalSize += fileInfo.Length;
            }

            if (totalSize > maxSize)
            {
                throw new Exception(string.Format("The total size of input files ({0} bytes) exceeds limit ({1} bytes)", totalSize, maxSize));
            }

            using (var outputFile = File.OpenWrite(outputPath))
            {
                foreach (var inputPath in inputPathList)
                {
                    using (var inputFile = File.OpenRead(inputPath))
                    {
                        inputFile.CopyTo(outputFile);
                    }
                }
            }
        }
    }
}
