﻿using Nintendo.Nact;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Utilities;
using Nintendo.Nact.Utilities.VisualStudio;
using System;

namespace SigloNact.BuiltIns.BuildSystem
{
    [NactFunctionContainer]
    public static class VisualSudioFunctions
    {
        [NactFunction]
        public static string GetVisualStudioVersionString(string majorMinorString)
        {
            if (majorMinorString == "15.0")
            {
                var vsInstance = NactPluginGlobal.VisualStudioCollection.GetVisualStudio(VisualStudioCollection.VisualStudio15ChannelId);
                return vsInstance?.InstallationVersion;
            }

            VisualStudioVersion vsVersion;
            try
            {
                vsVersion = VisualStudioUtil.MajorMinorStringToVsVersion(majorMinorString);
            }
            catch (ArgumentException e)
            {
                throw new Nintendo.Nact.ErrorException(e.Message, null, e);
            }

            string installationPath = VisualStudioUtil.GetVsInstallationPath(vsVersion);
            if (installationPath == null)
            {
                // VS がインストールされていなければ undefined を返す
                return null;
            }

            // バージョンを取得して返す
            Version version = VisualStudioUtil.GetVsVersionNumberFromProductUpdateExtension(installationPath);
            if (version == null)
            {
                // Update がインストールされていなければ (RTM) を返す
                return "(RTM)";
            }
            return version.ToString();
        }
    }
}
