﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using Nintendo.Nact.Utilities.ProgramExecution;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using static System.FormattableString;

namespace SigloNact.BuiltIns.Authoring
{
    [NactActionFunctionContainer]
    public static class AuthoringActions
    {
        [NactActionFunction]
        public static NactActionResult CleanupDataRegion(
            INactActionContext context,
            FilePath path)
        {
            var helper = context.Helper;

            FileSystemOperationUtil.DeleteDirectory(path.PathString, true, true);

            return helper.FinishAsSuccess();
        }

        [NactActionFunction]
        public static NactActionResult CreateDataRegionJunction(
            INactActionContext context,
            FilePath source,
            FilePath destination)
        {
            var helper = context.Helper;

            FileSystemOperationUtil.DeleteDirectory(destination.PathString, true, true);

            var programResult = CreateJunction(helper, source, destination);

            return helper.FinishWithExitCode(programResult.ExitCode);
        }

        private static ProgramExecutionResult CreateJunction(INactActionHelper helper, FilePath source, FilePath destination)
        {
            // ジャンクションを作るには、リパースポイントのデータを自分で生成して DeviceIoControl で設定しないといけない。
            // 簡単のため、コマンドプロンプトの mklink コマンドを使用してジャンクションを作成する。
            var cmdPath = FilePath.CreateLocalFileSystemPath(ProgramExecutionUtil.SearchExecutablePath("cmd.exe"));
            var args = Invariant($"/c mklink /j \"{destination}\" \"{source}\"");

            return helper.ExecuteProgram(
                cmdPath,
                args,
                additionalEnvironmentVariables: null,
                outputModifier: x => x.Clear());  // 成功時にもログ出力があるので無視する
        }

        [NactActionFunction]
        public static NactActionResult CreateDataRegionHardLinks(
            INactActionContext context,
            FilePath destinationDirectory,
            IReadOnlyCollection<FilePath> sourceFiles,
            IReadOnlyCollection<string> destinationNames)
        {
            var helper = context.Helper;

            FileSystemOperationUtil.DeleteDirectory(destinationDirectory.PathString, true, true);

            foreach (var (source, destinationName) in sourceFiles.Zip(destinationNames, (x, y) => (x, y)))
            {
                var destination = destinationDirectory.Combine(destinationName);

                // TODO: EnsureDirectory するユーティリティ
                // 冒頭の DeleteDirectory で Nact が用意した出力ディレクトリを削除してしまっているので、作成する。
                Util.EnsureDirectory(destination.Parent.PathString);

                // TODO: CopyFile にハードリンク許可フラグを追加し、CopyFile の最適化としてハードリンクを実施する
                Util.CreateHardLink(source.PathString, destination.PathString);

                helper.AddReadFile(source);
                helper.AddWriteFile(destination);
            }

            return helper.FinishAsSuccess();
        }
    }
}
