﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.SigloBuild.Settings
{
    public sealed class BuildSettings
    {
        private static readonly string ToolChainsXmlResourceName = @"Nintendo.SigloBuild.ToolChains.xml";

        public ToolChains ToolChains { get; }

        private BuildSettings()
        {
            using (var stream = typeof(BuildSettings).Assembly.GetManifestResourceStream(ToolChainsXmlResourceName))
            {
                this.ToolChains = new ToolChains(stream);
            }
        }

        public static BuildSettings Create()
        {
            return new BuildSettings();
        }
    }
}
