﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Construction;

namespace Nintendo.MakeVisualStudioProject
{
    public class Log
    {
        public static bool EnableInfoLogging { get; set; } = false;

        public static void Print(string format, params object[] args)
        {
            Console.WriteLine(string.Format(format, args));
        }

        public static void Error(string format, params object[] args)
        {
            var str = string.Format(format, args);

            foreach (var line in str.Split(new[] { "\r\n", "\n" }, StringSplitOptions.None))
            {
                Console.Error.WriteLine("[ERR] " + line);
            }
        }

        public static void Warn(string format, params object[] args)
        {
            var str = string.Format(format, args);

            foreach (var line in str.Split(new[] { "\r\n", "\n" }, StringSplitOptions.None))
            {
                Console.Error.WriteLine("[WRN] " + line);
            }
        }

        public static void Info(string format, params object[] args)
        {
            if (!EnableInfoLogging)
            {
                return;
            }

            var str = string.Format(format, args);

            foreach (var line in str.Split(new[] { "\r\n", "\n" }, StringSplitOptions.None))
            {
                Console.Error.WriteLine("[IFO] " + line);
            }
        }

        public static void WarnProjectElement(ProjectElement e, string format, params object[] args)
        {
            Log.Warn("({0}:{1},{2}) {3}",
                string.IsNullOrEmpty(e.Location.File) ? "<unnamed>" : Path.GetFileName(e.Location.File),
                e.Location.Line,
                e.Location.Column,
                string.Format(format, args));
        }

        public static void ReportException(Exception ex)
        {
            Error("{0}: {1}", ex.GetType().ToString(), ex.Message);
        }
    }
}
